/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nio;

import java.math.BigInteger;
import java.nio.BufferUnderflowException;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispEndianness;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.SubrUtils;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/06/12
 */
public class BlobSintSetS extends Subr {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	public Datum eval(Datum body, Environment env, LispMessage mesg) {
		ConsIterator itr = new ConsIterator(body);
		int s = SubrUtils.nextSmallInt(itr, mesg, body);
		Datum e = SubrUtils.nextIf(itr, mesg, body);
		Datum b = SubrUtils.nextIf(itr, mesg, body);
		int k = SubrUtils.nextSmallInt(itr, mesg, body);
		Datum z = SubrUtils.nextIf(itr, mesg, body);

		SubrUtils.checkTerminated(itr, body, mesg);
		if(!(e instanceof LispEndianness.Endian)) {
			throw mesg.getError("err.srfi74.require.endianness", e);
		} else if(!(b instanceof LispBlob)) {
			throw mesg.getError("err.srfi74.require.blob", b);
		} else if(!(z instanceof LispInteger)) {
			throw mesg.getError("err.require.int", z);
		} else {
			BigInteger x = z.getBigInteger();
			BigInteger max = BigInteger.ONE.shiftLeft(s * 8 - 1);
			BigInteger min =
				BigInteger.ONE.shiftLeft(s * 8 - 1).negate();

			try {
				if(x.compareTo(max) >= 0 || x.compareTo(min) < 0) {
					throw mesg.getError("err.srfi74.value.outofrange",
							z);
				} else {
					((LispBlob)b).order((LispEndianness.Endian)e);
					((LispBlob)b).put(s, k, x);
				}
				return Undef.UNDEF;
			} catch(BufferUnderflowException f) {
				throw mesg.getError("err.srfi74.blob.outofrange",
						"" + k);
			} catch(IllegalArgumentException f) {
				throw mesg.getError("err.srfi74.index.invalid",
						"" + k);
			}
		}
	}

}
