/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractShortVector;
import net.morilib.util.primitive.ShortCollection;

public class ShortArrayVector
extends AbstractShortVector
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 3332872309405682099L;
    private short[] array;
    private transient int size;

    public ShortArrayVector(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new short[initialCapacity];
    }

    public ShortArrayVector() {
        this(10);
    }

    public ShortArrayVector(short[] bytes) {
        this.array = new short[bytes.length];
        this.size = this.array.length;
        System.arraycopy(bytes, 0, this.array, 0, bytes.length);
    }

    public ShortArrayVector(ShortCollection a) {
        this.array = a.toShortArray();
        this.size = this.array.length;
    }

    public ShortArrayVector(ShortCollection ... as) {
        this.size = 0;
        ShortCollection[] shortCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            ShortCollection a = shortCollectionArray[n2];
            this.size += a.size();
            ++n2;
        }
        int s2 = 0;
        this.array = new short[this.size];
        ShortCollection[] shortCollectionArray2 = as;
        int n3 = as.length;
        n = 0;
        while (n < n3) {
            ShortCollection a = shortCollectionArray2[n];
            short[] b = a.toShortArray();
            System.arraycopy(b, 0, this.array, s2, b.length);
            s2 += a.size();
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ShortArrayVector(Collection<? extends ShortCollection> as) {
        this.size = 0;
        for (ShortCollection shortCollection : as) {
            this.size += shortCollection.size();
        }
        boolean bl = false;
        this.array = new short[this.size];
        for (ShortCollection shortCollection : as) {
            void var2_7;
            short[] b = shortCollection.toShortArray();
            System.arraycopy(b, 0, this.array, (int)var2_7, b.length);
            var2_7 += shortCollection.size();
        }
    }

    public void ensureCapacity(int nsize) {
        if (nsize > this.array.length) {
            int ns = nsize;
            while (ns < this.array.length) {
                int n = ns = this.array.length < 0x4CCCCCCA ? this.array.length / 3 * 5 + 1 : Integer.MAX_VALUE;
            }
            short[] b = new short[ns];
            System.arraycopy(this.array, 0, b, 0, this.size);
            this.array = b;
        }
    }

    @Override
    public void addShort(int index, short v) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        ++this.modCount;
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = v;
        ++this.size;
    }

    @Override
    public boolean addAllShort(int index, ShortCollection a) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        short[] b = a.toShortArray();
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public short getShort(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public short removeAt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        short res = this.array[index];
        ++this.modCount;
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        return res;
    }

    @Override
    public short setShort(int index, short v) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        short res = this.array[index];
        ++this.modCount;
        this.array[index] = v;
        return res;
    }

    @Override
    public boolean addAllShort(ShortCollection a) {
        short[] b = a.toShortArray();
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllShort(ShortCollection ... as) {
        int nsize = 0;
        ShortCollection[] shortCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            ShortCollection a = shortCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            int s2 = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            ShortCollection[] shortCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                ShortCollection a = shortCollectionArray2[n];
                short[] b = a.toShortArray();
                System.arraycopy(b, 0, this.array, s2, b.length);
                s2 += a.size();
                ++n;
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllShort(Collection<? extends ShortCollection> as) {
        int nsize = 0;
        for (ShortCollection shortCollection : as) {
            nsize += shortCollection.size();
        }
        if (nsize > 0) {
            int n = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            for (ShortCollection shortCollection : as) {
                void var3_8;
                short[] b = shortCollection.toShortArray();
                System.arraycopy(b, 0, this.array, (int)var3_8, b.length);
                var3_8 += shortCollection.size();
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAllShort(short[] b) {
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllShort(int index, short[] b) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (b.length == 0) {
            return false;
        }
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public short[] toShortArray() {
        short[] b = new short[this.size];
        System.arraycopy(this.array, 0, b, 0, this.size);
        return b;
    }

    @Override
    public short[] toShortArray(short[] a) {
        if (a.length < this.size) {
            return this.toShortArray();
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        return a;
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = this.array.length;
    }
}

