/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractDoubleVector;
import net.morilib.util.primitive.DoubleCollection;

public class DoubleArrayVector
extends AbstractDoubleVector
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 3332872309405682099L;
    private double[] array;
    private transient int size;

    public DoubleArrayVector(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new double[initialCapacity];
    }

    public DoubleArrayVector() {
        this(10);
    }

    public DoubleArrayVector(double[] bytes) {
        this.array = new double[bytes.length];
        this.size = this.array.length;
        System.arraycopy(bytes, 0, this.array, 0, bytes.length);
    }

    public DoubleArrayVector(DoubleCollection a) {
        this.array = a.toDoubleArray();
        this.size = this.array.length;
    }

    public DoubleArrayVector(DoubleCollection ... as) {
        this.size = 0;
        DoubleCollection[] doubleCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleCollection a = doubleCollectionArray[n2];
            this.size += a.size();
            ++n2;
        }
        int s2 = 0;
        this.array = new double[this.size];
        DoubleCollection[] doubleCollectionArray2 = as;
        int n3 = as.length;
        n = 0;
        while (n < n3) {
            DoubleCollection a = doubleCollectionArray2[n];
            double[] b = a.toDoubleArray();
            System.arraycopy(b, 0, this.array, s2, b.length);
            s2 += a.size();
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public DoubleArrayVector(Collection<? extends DoubleCollection> as) {
        this.size = 0;
        for (DoubleCollection doubleCollection : as) {
            this.size += doubleCollection.size();
        }
        boolean bl = false;
        this.array = new double[this.size];
        for (DoubleCollection doubleCollection : as) {
            void var2_7;
            double[] b = doubleCollection.toDoubleArray();
            System.arraycopy(b, 0, this.array, (int)var2_7, b.length);
            var2_7 += doubleCollection.size();
        }
    }

    public void ensureCapacity(int nsize) {
        if (nsize > this.array.length) {
            int ns = nsize;
            while (ns < this.array.length) {
                int n = ns = this.array.length < 0x4CCCCCCA ? this.array.length / 3 * 5 + 1 : Integer.MAX_VALUE;
            }
            double[] b = new double[ns];
            System.arraycopy(this.array, 0, b, 0, this.size);
            this.array = b;
        }
    }

    @Override
    public void addDouble(int index, double v) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        ++this.modCount;
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = v;
        ++this.size;
    }

    @Override
    public boolean addAllDouble(int index, DoubleCollection a) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        double[] b = a.toDoubleArray();
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public double getDouble(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public double removeAt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        double res = this.array[index];
        ++this.modCount;
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        return res;
    }

    @Override
    public double setDouble(int index, double v) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        double res = this.array[index];
        ++this.modCount;
        this.array[index] = v;
        return res;
    }

    @Override
    public boolean addAllDouble(DoubleCollection a) {
        double[] b = a.toDoubleArray();
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllDouble(DoubleCollection ... as) {
        int nsize = 0;
        DoubleCollection[] doubleCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleCollection a = doubleCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            int s2 = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            DoubleCollection[] doubleCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                DoubleCollection a = doubleCollectionArray2[n];
                double[] b = a.toDoubleArray();
                System.arraycopy(b, 0, this.array, s2, b.length);
                s2 += a.size();
                ++n;
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllDouble(Collection<? extends DoubleCollection> as) {
        int nsize = 0;
        for (DoubleCollection doubleCollection : as) {
            nsize += doubleCollection.size();
        }
        if (nsize > 0) {
            int n = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            for (DoubleCollection doubleCollection : as) {
                void var3_8;
                double[] b = doubleCollection.toDoubleArray();
                System.arraycopy(b, 0, this.array, (int)var3_8, b.length);
                var3_8 += doubleCollection.size();
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAllDouble(double[] b) {
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllDouble(int index, double[] b) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (b.length == 0) {
            return false;
        }
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double[] toDoubleArray() {
        double[] b = new double[this.size];
        System.arraycopy(this.array, 0, b, 0, this.size);
        return b;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        if (a.length < this.size) {
            return this.toDoubleArray();
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        return a;
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = this.array.length;
    }
}

