/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.iterator;

import net.morilib.util.iterator.IndexIterator;

public class ArrayIterator<E>
extends IndexIterator<E> {
    private E[] array;

    public ArrayIterator(E ... objs) {
        super(0, objs.length);
        this.array = objs;
    }

    public ArrayIterator(int begin, int end, E ... objs) {
        super(begin, end);
        this.array = objs;
    }

    public ArrayIterator(int length, E ... objs) {
        super(length, 0, objs.length);
        this.array = objs;
    }

    public ArrayIterator(int index, int begin, int end, E ... objs) {
        super(index, begin, end);
        this.array = objs;
    }

    @Override
    protected E get(int index) {
        if (!this.isInRange(index)) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.array[index];
    }

    @Override
    protected void set(int index, E o) {
        throw new UnsupportedOperationException();
    }
}

