/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

public class IncludeReader
extends Reader {
    private Stack<Reader> readers = new Stack();

    public IncludeReader(Reader reader) {
        this.readers.push(reader);
    }

    @Override
    public void close() throws IOException {
        while (!this.readers.isEmpty()) {
            this.readers.pop().close();
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int bt = 0;
        while (!this.readers.isEmpty() && (bt += this.readers.peek().read(cbuf, off + bt, len - bt)) < len) {
            this.readers.pop().close();
        }
        return bt;
    }

    public void include(Reader rd) {
        this.readers.push(rd);
    }
}

