/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.options;

import net.morilib.options.ArgsIterator;
import net.morilib.options.IllegalCommandLineException;
import net.morilib.options.OperandProcessor;
import net.morilib.options.OptionObject;
import net.morilib.options.OptionProcessor;

public final class OptionUtils {
    private OptionUtils() {
    }

    private static Object checkreq(boolean req) {
        return req ? Boolean.FALSE : null;
    }

    private static Object checkopt(boolean req, boolean opt, ArgsIterator args) {
        if (!req && !opt) {
            return Boolean.FALSE;
        }
        return args.hasNext() ? args.next() : null;
    }

    static Object processLong(int optchar, String s, boolean req, boolean opt, ArgsIterator args) {
        if (!args.isLongOption(optchar)) {
            return Boolean.FALSE;
        }
        String a = args.peek();
        if (a.indexOf(s) != 2) {
            return Boolean.FALSE;
        }
        int x = s.length() + 2;
        if (x < a.length()) {
            if (a.charAt(x) != '=') {
                return Boolean.FALSE;
            }
            if (OptionUtils.checkopt(req, opt, args) == Boolean.FALSE) {
                args.forward();
                return null;
            }
            args.forward();
            return a.substring(++x);
        }
        if (args.forward().isDelim(optchar)) {
            return OptionUtils.checkreq(req);
        }
        Object o = OptionUtils.checkopt(req, opt, args);
        if (o == Boolean.FALSE) {
            return null;
        }
        return o;
    }

    static Object process(int optchar, char c, boolean req, boolean opt, ArgsIterator args) {
        int x;
        String a;
        if (args.isShortOption(optchar) && (a = args.peek()).indexOf(c) == 1) {
            if (req || opt) {
                if (a.length() > 2) {
                    args.forward();
                    return a.substring(2);
                }
                if (!args.forward().isDelim(optchar)) {
                    return OptionUtils.checkopt(req, opt, args);
                }
                Object o = OptionUtils.checkreq(req);
                if (o == Boolean.FALSE) {
                    throw new IllegalCommandLineException("the option can not have any arguments");
                }
                return o;
            }
            if (args.forwardShort().isDelim(optchar)) {
                return OptionUtils.checkreq(req);
            }
            return null;
        }
        if (args.isLongOption(optchar) && (x = (a = args.peek()).indexOf(c)) == 2) {
            if (a.length() > 3) {
                if (OptionUtils.checkopt(req, opt, args) == Boolean.FALSE) {
                    return Boolean.FALSE;
                }
                if (a.charAt(x + 1) == '=') {
                    ++x;
                }
                return a.substring(x + 1);
            }
            if (args.forward().isDelim(optchar)) {
                return OptionUtils.checkreq(req);
            }
            return OptionUtils.checkopt(req, opt, args);
        }
        return Boolean.FALSE;
    }

    static Object process(int oc, String s, boolean req, boolean opt, ArgsIterator args) {
        switch (s.length()) {
            case 0: {
                throw new IllegalArgumentException();
            }
            case 1: {
                return OptionUtils.process(oc, s.charAt(0), req, opt, args);
            }
        }
        return OptionUtils.processLong(oc, s, req, opt, args);
    }

    public static Object process(int optchar, String[] args, OptionObject[] options, OptionProcessor unrecognized, OperandProcessor operand, Object extra) {
        int n;
        int n2;
        Object[] objectArray;
        ArgsIterator a2 = new ArgsIterator(args);
        Object e2 = extra;
        block0: while (a2.isOption(optchar)) {
            objectArray = options;
            n2 = options.length;
            n = 0;
            while (n < n2) {
                Object o = objectArray[n];
                for (String s : o.getNames()) {
                    Object x = OptionUtils.process(optchar, s, o.isArgumentRequired(), o.isArgumentOptional(), a2);
                    if (x == Boolean.FALSE) continue;
                    e2 = o.getProcessor().call((OptionObject)o, s, (String)x, e2);
                    continue block0;
                }
                ++n;
            }
            e2 = unrecognized.call(null, a2.next().replaceFirst("^-+", ""), null, extra);
        }
        objectArray = a2.operands();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Object s = objectArray[n];
            e2 = operand.call((String)s, e2);
            ++n;
        }
        return e2;
    }

    public static Object process(String[] args, OptionObject[] options, OptionProcessor unrecognized, OperandProcessor operand, Object extra) {
        return OptionUtils.process(45, args, options, unrecognized, operand, extra);
    }
}

