/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.ntp;

import java.util.Date;

public class NTPTimestamp {
    private static final long OFFSET_1970_MS = 2208988800000L;
    private static final long OFFSET_1970_S = 2208988800L;
    private long seconds;
    private long fraction;

    public NTPTimestamp(long seconds, long fraction) {
        this.seconds = seconds;
        this.fraction = fraction;
    }

    public static NTPTimestamp getInstance(long time) {
        long f = 0L;
        long t = time;
        double k = 500.0;
        long s = (int)(t / 1000L);
        int g = (int)(t % 1000L);
        int i = 31;
        while (k >= 1.0) {
            if (g > i) {
                f |= 1L << i;
                g -= (int)k;
            }
            k /= 2.0;
            --i;
        }
        return new NTPTimestamp(s + 2208988800L, f);
    }

    public static NTPTimestamp localCurrentTime() {
        return NTPTimestamp.getInstance(System.currentTimeMillis());
    }

    public long getTime() {
        long r = 0L;
        double k = 500.0;
        int i = 31;
        while (k > 0.0) {
            if ((this.fraction & 1L << i) != 0L) {
                r += (long)((int)k);
            }
            k /= 2.0;
            --i;
        }
        return (r += this.seconds * 1000L) - 2208988800000L;
    }

    public Date getDate() {
        return new Date(this.getTime());
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getFraction() {
        return this.fraction;
    }

    public NTPTimestamp add(long l) {
        long f = this.fraction + (l & 0xFFFFFFFFL);
        long c = f >> 32;
        long s = this.seconds + (l >> 32) + c;
        return new NTPTimestamp(s, f &= 0xFFFFFFFFL);
    }

    public long subtract(NTPTimestamp t) {
        long f = this.fraction - t.fraction;
        long c = f >> 32;
        long s = this.seconds - t.seconds + c;
        return s << 32 | (f &= 0xFFFFFFFFL);
    }

    public int hashCode() {
        return (int)this.fraction;
    }

    public boolean equals(Object o) {
        if (o instanceof NTPTimestamp) {
            NTPTimestamp n = (NTPTimestamp)o;
            return this.seconds == n.seconds && this.fraction == n.fraction;
        }
        return false;
    }
}

