/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist.discrete;

import net.morilib.math.special.Gamma2;
import net.morilib.math.stat.dist.AbstractDiscreteDistribution;

public class PoissonDistribution
extends AbstractDiscreteDistribution {
    private double lambda;

    public PoissonDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.lambda = lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    @Override
    public double expectedValue() {
        return this.lambda;
    }

    @Override
    public double variance() {
        return this.lambda;
    }

    @Override
    public double mode() {
        return Math.IEEEremainder(this.lambda, 1.0) == 0.0 ? this.lambda - 1.0 : Math.floor(this.lambda);
    }

    @Override
    public double median() {
        return Math.floor(this.lambda + 0.3333333333333333 - 0.02 / this.lambda);
    }

    @Override
    public double skewness() {
        return 1.0 / Math.sqrt(this.lambda);
    }

    @Override
    public double kurtosis() {
        return 1.0 / this.lambda;
    }

    @Override
    public double f(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        double r = Math.log(this.lambda) * (double)n - Gamma2.lnGamma(n + 1) - this.lambda;
        return Math.exp(r);
    }

    @Override
    public boolean isInSupport(int n) {
        return n >= 0;
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double l = Gamma2.lnIncompleteGammaLower(Math.floor(x + 1.0), this.lambda);
        return 1.0 - Math.exp(l -= Gamma2.lnGamma(Math.floor(x + 1.0)));
    }

    @Override
    public int supportMinimum() {
        return 0;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.lambda);
    }

    public boolean equals(Object o) {
        if (o instanceof PoissonDistribution) {
            PoissonDistribution d = (PoissonDistribution)o;
            return this.lambda == d.lambda;
        }
        return false;
    }
}

