/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist;

import net.morilib.math.stat.StatisticsUtils;
import net.morilib.math.stat.dist.AbstractDiscreteDistribution;

public class Histogram
extends AbstractDiscreteDistribution {
    int[] frequency;
    double min;
    double max;
    double width;
    double mean;
    double variance;
    double mode;
    double median;
    double skewness;
    double kurtosis;
    int sum;

    public Histogram(double ... vals) {
        int k = (int)Math.sqrt(vals.length);
        this.min = StatisticsUtils.min(vals);
        this.max = StatisticsUtils.min(vals);
        this.width = (this.max - this.min) / (double)k;
        this.mean = StatisticsUtils.mean(vals);
        this.mode = StatisticsUtils.mode(vals);
        this.median = StatisticsUtils.median(vals);
        this.variance = StatisticsUtils.variance(vals);
        this.skewness = StatisticsUtils.skewness(vals);
        this.kurtosis = StatisticsUtils.kurtosis(vals);
        this.sum = vals.length;
        this.frequency = StatisticsUtils.toHistogram(vals);
    }

    public int getBins() {
        return this.frequency.length;
    }

    public int frequency(int n) {
        return this.frequency[n];
    }

    @Override
    public double f(int n) {
        return this.frequency[n] / this.sum;
    }

    @Override
    public double expectedValue() {
        return this.mean;
    }

    @Override
    public double variance() {
        return this.variance;
    }

    @Override
    public double mode() {
        return this.mode;
    }

    @Override
    public double median() {
        return this.median;
    }

    @Override
    public double skewness() {
        return this.skewness;
    }

    @Override
    public double kurtosis() {
        return this.kurtosis;
    }

    @Override
    public boolean isInSupport(int n) {
        return n >= 0 && n < this.frequency.length;
    }

    @Override
    public int supportMinimum() {
        return 0;
    }
}

