/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.special;

import net.morilib.lang.number.complex.ComplexDouble;
import net.morilib.lang.number.complex.ComplexDoubleTransform;
import net.morilib.lang.number.complex.ComplexMath;
import net.morilib.lang.number.complex.RectanglarComplexDouble;
import net.morilib.lang.number.complex.RectanglarComplexDoubleRegister;
import net.morilib.lang.transform.DoubleTransform;
import net.morilib.math.Math2;
import net.morilib.math.special.GammaFunctions;

public class CylinderFunctions {
    static final double G_LOG2 = 0.5772156649015329 - Math.log(2.0);
    public static final DoubleTransform J0 = CylinderFunctions.getJ(0.0);
    public static final DoubleTransform J1 = CylinderFunctions.getJ(1.0);
    public static final DoubleTransform I0 = CylinderFunctions.getI(0.0);
    public static final DoubleTransform I1 = CylinderFunctions.getI(1.0);

    static double gosa(ComplexDouble r, ComplexDouble rold) {
        if (Double.isInfinite(rold.realPart())) {
            return Double.POSITIVE_INFINITY;
        }
        return r.subtract(rold).abs() / r.add(rold).abs();
    }

    static double JbyIntegral(double x, int n) {
        int n0 = ((x > (double)n ? (int)x : n) & 0xFFFFFFFE) * 1000;
        double h = Math.PI / (double)n0;
        double r = 0.0;
        r = 1.0 * h / 3.0;
        int i = 1;
        while (i < n0 - 1) {
            double xi0 = h * (double)i;
            double xi1 = h * (double)(i + 1);
            r += 4.0 * Math.cos((double)n * xi0 - x * Math.sin(xi0)) * h / 3.0;
            r += 2.0 * Math.cos((double)n * xi1 - x * Math.sin(xi1)) * h / 3.0;
            i += 2;
        }
        return (r += Math.cos((double)n * Math.PI) * h / 3.0) / Math.PI;
    }

    static double bySeriesExpansion(double x, double nu, boolean isI) {
        double r = 0.0;
        double rold = Double.MIN_VALUE;
        double mf = 1.0;
        double kf = 1.0;
        kf = GammaFunctions.GAMMA.f(nu + 1.0);
        double df = Math.pow(x / 2.0, nu);
        r = df / kf;
        int m = 1;
        while (Math.abs(r - rold) > 1.0E-7) {
            rold = r;
            df = df * x * x / 4.0;
            double d = df / (mf *= (double)m) / (kf *= (double)m + nu);
            r = isI ? (r += d) : (r += !(m & true) ? d : -d);
            ++m;
        }
        return r;
    }

    static ComplexDouble bySeriesExpansion(ComplexDouble z, double nu, boolean isI) {
        ComplexDouble rold = ComplexDouble.REAL_POSITIVE_INFINITY;
        double mf = 1.0;
        ComplexDouble z2 = z.divide(2.0);
        double kf = GammaFunctions.GAMMA.f(nu + 1.0);
        RectanglarComplexDoubleRegister df = new RectanglarComplexDoubleRegister(ComplexMath.expt(z2, nu));
        RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(df.toComplex().divide(kf));
        int m = 1;
        while (r.toComplex().subtract(rold).abs() > 1.0E-7) {
            rold = r.toComplex();
            df.multiply(z2).multiply(z2);
            ComplexDouble d = df.toComplex().divide(mf *= (double)m).divide(kf *= (double)m + nu);
            if (isI) {
                r.add(d);
            } else if (!(m & true)) {
                r.add(d);
            } else {
                r.subtract(d);
            }
            ++m;
        }
        return r.toComplex();
    }

    static double nu_m2(double nu, int m) {
        double r = 1.0;
        int i = 1;
        while (i <= m) {
            r *= ((double)(2 * m - 1) - 4.0 * nu * nu) / 4.0 / (double)m;
            ++i;
        }
        return r;
    }

    static ComplexDouble JbyAsymptoticExpansion(ComplexDouble z, double nu) {
        ComplexDouble w = ComplexMath.sqrt(((ComplexDouble)z.invert()).multiply(0.6366197723675814));
        return w.multiply(ComplexMath.cos(z.subtract(Math.PI * nu / 2.0 + 0.7853981633974483)));
    }

    static ComplexDouble YbyAsymptoticExpansion(ComplexDouble z, double nu) {
        ComplexDouble w = ComplexMath.sqrt(((ComplexDouble)z.invert()).multiply(0.6366197723675814));
        return w.multiply(ComplexMath.sin(z.subtract(Math.PI * nu / 2.0 + 0.7853981633974483)));
    }

    static double J0to2(double x, double nu) {
        if (x < 30.0) {
            return CylinderFunctions.bySeriesExpansion(x, nu, false);
        }
        return Math.sqrt(0.6366197723675814 / x) * Math.cos(x - Math.PI * nu / 2.0 - 0.7853981633974483);
    }

    static ComplexDouble J0to2(ComplexDouble z, double nu) {
        if (z.abs() < 30.0) {
            return CylinderFunctions.bySeriesExpansion(z, nu, false);
        }
        return CylinderFunctions.JbyAsymptoticExpansion(z, nu);
    }

    static double subu(double r, double x, int n) {
        int m = 1;
        double s = 0.0;
        double t = 1.0;
        int i = 1;
        while (i <= n) {
            s += 1.0 / (double)i;
            t *= x / 2.0 / (double)i;
            ++i;
        }
        double rold = Double.MAX_VALUE;
        r += G_LOG2 * CylinderFunctions.J(x, (double)n);
        r -= t * s;
        while (Math.abs(rold - r) > 1.0E-12) {
            rold = r;
            r = (m & 1) == 0 ? (r -= t * s) : (r += (t *= x * x / 4.0 / (double)m / (double)(n + m)) * (s += 1.0 / (double)(n + m)));
            ++m;
        }
        return r;
    }

    static ComplexDouble subu(ComplexDouble r, ComplexDouble z, int n) {
        ComplexDouble w = z.divide(2.0);
        int m = 1;
        double s = 0.0;
        RectanglarComplexDoubleRegister t = new RectanglarComplexDoubleRegister(1.0, 0.0);
        int i = 1;
        while (i <= n) {
            s += 1.0 / (double)i;
            t.multiply(w).divide(i);
            ++i;
        }
        ComplexDouble rold = ComplexDouble.REAL_POSITIVE_INFINITY;
        RectanglarComplexDoubleRegister res = new RectanglarComplexDoubleRegister(r.add(CylinderFunctions.J(z, (double)n).multiply(G_LOG2)));
        res.subtract(t.toComplex().multiply(s));
        while (rold.subtract(res.toComplex()).abs() > 1.0E-12) {
            rold = res.toComplex();
            s += 1.0 / (double)(n + m);
            t.multiply(w).multiply(w).divide(m * (n + m));
            if ((m & 1) == 0) {
                res.subtract(t.toComplex().multiply(s));
            } else {
                res.add(t.toComplex().multiply(s));
            }
            ++m;
        }
        return res.toComplex();
    }

    static double Y0to2(double x, int n) {
        if (x >= 30.0) {
            return Math.sqrt(0.6366197723675814 / x) * Math.sin(x - Math.PI * (double)n / 2.0 - 0.7853981633974483);
        }
        if (n == 1) {
            return CylinderFunctions.subu(CylinderFunctions.J(x, 1.0) * Math.log(x) - CylinderFunctions.J(x, 0.0) * 1.0 / x, x, 1) * 2.0 / Math.PI;
        }
        return CylinderFunctions.subu(CylinderFunctions.J(x, 0.0) * Math.log(x), x, 0) * 2.0 / Math.PI;
    }

    static ComplexDouble Y0to2(ComplexDouble z, int n) {
        if (z.abs() >= 30.0) {
            return CylinderFunctions.YbyAsymptoticExpansion(z, n);
        }
        if (n == 1) {
            return CylinderFunctions.subu(CylinderFunctions.J(z, 1.0).multiply(ComplexMath.log(z)).subtract(CylinderFunctions.J(z, 0.0).multiply((ComplexDouble)z.invert())), z, 1).multiply(0.6366197723675814);
        }
        return CylinderFunctions.subu(CylinderFunctions.J(z, 0.0).multiply(ComplexMath.log(z)), z, 0).multiply(0.6366197723675814);
    }

    static double recurrenceJY(double x, double nu, double x0, double x1) {
        int n = (int)Math.floor(nu);
        double w = Math2.decimalPart(nu);
        double j0 = 0.0;
        double j1 = x0;
        double r = x1;
        int i = 2;
        while (i <= n) {
            j0 = j1;
            j1 = r;
            r = j1 * (2.0 * ((double)(i - 1) + w)) / x - j0;
            ++i;
        }
        return r;
    }

    static ComplexDouble recurrenceJY(ComplexDouble z, double nu, ComplexDouble z0, ComplexDouble z1) {
        int n = (int)Math.floor(nu);
        double w = Math2.decimalPart(nu);
        ComplexDouble j0 = null;
        ComplexDouble j1 = z0;
        RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(z1);
        int i = 2;
        while (i <= n) {
            j0 = j1;
            j1 = r.toComplex();
            r.multiply(2.0 * ((double)(i - 1) + w)).divide(z).subtract(j0);
            ++i;
        }
        return r.toComplex();
    }

    public static DoubleTransform getJ(double nu) {
        return new _Jn(nu);
    }

    public static ComplexDoubleTransform getJC(double nu) {
        return new _JnC(nu);
    }

    public static DoubleTransform getDxJ(double nu) {
        return new _JnD(nu);
    }

    public static ComplexDoubleTransform getDzJC(double nu) {
        return new _JnDC(nu);
    }

    public static DoubleTransform getY(double nu) {
        return new _Yn(nu);
    }

    public static ComplexDoubleTransform getYC(double nu) {
        return new _YnC(nu);
    }

    public static double J(double x, double nu) {
        return CylinderFunctions.getJ(nu).f(x);
    }

    public static ComplexDouble J(ComplexDouble z, double nu) {
        return CylinderFunctions.getJC(nu).f(z);
    }

    public static double Y(double x, double nu) {
        return CylinderFunctions.getY(nu).f(x);
    }

    public static ComplexDouble Y(ComplexDouble z, double nu) {
        return CylinderFunctions.getYC(nu).f(z);
    }

    static double IbyAsymptoticExpansion(double x, double nu) {
        double w1 = Math.exp(x) / Math.sqrt(x * (Math.PI * 2));
        return w1;
    }

    static ComplexDouble IbyAsymptoticExpansion(ComplexDouble z, double nu) {
        ComplexDouble w1 = ComplexMath.exp(z).divide(ComplexMath.sqrt(z.multiply(Math.PI * 2)));
        return w1;
    }

    static double I0to2(double x, double nu) {
        if (x <= 90.0) {
            return CylinderFunctions.bySeriesExpansion(x, nu, true);
        }
        return CylinderFunctions.IbyAsymptoticExpansion(x, nu);
    }

    static ComplexDouble I0to2(ComplexDouble z, double nu) {
        if (z.abs() <= 90.0) {
            return CylinderFunctions.bySeriesExpansion(z, nu, true);
        }
        return CylinderFunctions.IbyAsymptoticExpansion(z, nu);
    }

    static int pos(int n) {
        return n == 0 ? 1 : n;
    }

    static double _kninit(double x, int n) {
        if (n == 0) {
            return 0.0;
        }
        double p = 2.0 / x;
        int i = 1;
        while (i <= n - 1) {
            p *= (double)i / (x / 2.0);
            ++i;
        }
        double r = 0.0;
        int m = 0;
        while (m <= n - 1) {
            r += (m & 1) == 0 ? p : -p;
            p *= (double)(1 / CylinderFunctions.pos(n - 1 - m) / CylinderFunctions.pos(m)) * x * x / 4.0;
            ++m;
        }
        return r / 2.0;
    }

    static double _kn(double x, int n) {
        int m = 1;
        double s1 = 0.0;
        double s2 = 0.0;
        double t = 1.0;
        int i = 1;
        while (i <= n) {
            s2 += 1.0 / (double)i;
            t *= x / 2.0 / (double)i;
            ++i;
        }
        double rold = Double.MAX_VALUE;
        double r = 0.0;
        while (Math.abs(rold - r) > 1.0E-12) {
            rold = r;
            double q = Math.log(x / 2.0) - s1 / 2.0 - s2 / 2.0;
            r += t * (q += 0.5772156649015329);
            t *= x * x / 4.0 / (double)m / (double)(n + m);
            s1 += 1.0 / (double)m;
            s2 += 1.0 / (double)(n + m);
            ++m;
        }
        return CylinderFunctions._kninit(x, n) + ((n & 1) == 0 ? -r : r);
    }

    static double _K0to2(double x, double nu) {
        if (Math2.isInteger(nu)) {
            if (x > 40.0) {
                double w = Math.sqrt(1.5707963267948966 / x) * Math.exp(-x);
                return w * (1.0 + (4.0 * nu * nu - 1.0) / 4.0 / 2.0 / x);
            }
            return CylinderFunctions._kn(x, (int)nu);
        }
        if (x > 5.0) {
            double w = Math.sqrt(1.5707963267948966 / x) * Math.exp(-x);
            return w * (1.0 + (4.0 * nu * nu - 1.0) / 4.0 / 2.0 / x);
        }
        double w = CylinderFunctions.getI(-nu).f(x) - CylinderFunctions.getI(nu).f(x);
        return w / Math.sin(nu * Math.PI) * Math.PI / 2.0;
    }

    static ComplexDouble _kninit(ComplexDouble z, int n) {
        if (n == 0) {
            return ComplexDouble.ZERO;
        }
        RectanglarComplexDoubleRegister p = new RectanglarComplexDoubleRegister((ComplexDouble)((ComplexDouble)z.invert()).multiply(2));
        int i = 1;
        while (i <= n - 1) {
            p.multiply(i / 2).divide(z);
            ++i;
        }
        RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(0.0, 0.0);
        int m = 0;
        while (m <= n - 1) {
            if ((m & 1) == 0) {
                r.add(p.toComplex());
            } else {
                r.subtract(p.toComplex());
            }
            p.multiply(((ComplexDouble)z.power(2)).divide(CylinderFunctions.pos(n - 1 - m) * CylinderFunctions.pos(m) * 4));
            ++m;
        }
        return r.divide(2.0).toComplex();
    }

    static ComplexDouble _kn(ComplexDouble z, int n) {
        int m = 1;
        double s1 = 0.0;
        double s2 = 0.0;
        RectanglarComplexDoubleRegister t = new RectanglarComplexDoubleRegister(1.0, 0.0);
        int i = 1;
        while (i <= n) {
            s2 += 1.0 / (double)i;
            t.multiply(z).divide(2 / i);
            ++i;
        }
        ComplexDouble rold = ComplexDouble.REAL_POSITIVE_INFINITY;
        RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(0.0, 0.0);
        while (rold.subtract(r.toComplex()).abs() > 1.0E-12) {
            rold = r.toComplex();
            ComplexDouble q = ComplexMath.log(z.divide(2.0));
            q = q.subtract(s1 / 2.0).subtract(s2 / 2.0);
            q = q.add(0.5772156649015329);
            r.add(t.toComplex().multiply(q));
            t.multiply(((ComplexDouble)z.power(2)).divide(4.0).divide(m * (n + m)));
            s1 += 1.0 / (double)m;
            s2 += 1.0 / (double)(n + m);
            ++m;
        }
        if ((n & 1) == 0) {
            return CylinderFunctions._kninit(z, n).subtract(r.toComplex());
        }
        return CylinderFunctions._kninit(z, n).add(r.toComplex());
    }

    static ComplexDouble _K0to2(ComplexDouble z, double nu) {
        if (Math2.isInteger(nu)) {
            if (z.abs() > 40.0) {
                ComplexDouble w = ComplexMath.sqrt(((ComplexDouble)z.invert()).multiply(1.5707963267948966));
                w = w.multiply(ComplexMath.exp((ComplexDouble)z.negate()));
                return w.add(w.multiply(((ComplexDouble)z.invert()).multiply((4.0 * nu * nu - 1.0) / 4.0 / 2.0)));
            }
            return CylinderFunctions._kn(z, (int)nu);
        }
        if (z.abs() > 5.0) {
            ComplexDouble w = ComplexMath.sqrt(((ComplexDouble)z.invert()).multiply(1.5707963267948966));
            w = w.multiply(ComplexMath.exp((ComplexDouble)z.negate()));
            return w.add(w.multiply(((ComplexDouble)z.invert()).multiply((4.0 * nu * nu - 1.0) / 4.0 / 2.0)));
        }
        ComplexDouble w = CylinderFunctions.getIC(-nu).f(z).subtract(CylinderFunctions.getIC(nu).f(z));
        return w.multiply(1.5707963267948966 / Math.sin(nu * Math.PI));
    }

    public static DoubleTransform getI(double nu) {
        return new _In(nu);
    }

    public static ComplexDoubleTransform getIC(double nu) {
        return new _InC(nu);
    }

    public static DoubleTransform getK(double nu) {
        return new _Kn(nu);
    }

    public static ComplexDoubleTransform getKC(double nu) {
        return new _KnC(nu);
    }

    public static double I(double x, double nu) {
        return CylinderFunctions.getI(nu).f(x);
    }

    public static ComplexDouble I(ComplexDouble z, double nu) {
        return CylinderFunctions.getIC(nu).f(z);
    }

    public static double K(double x, double nu) {
        return CylinderFunctions.getK(nu).f(x);
    }

    public static ComplexDouble K(ComplexDouble z, double nu) {
        return CylinderFunctions.getKC(nu).f(z);
    }

    static class _In
    implements DoubleTransform {
        private double nu;

        _In(double nu) {
            this.nu = nu;
        }

        @Override
        public double f(double x) {
            if (x < 0.0) {
                return Math2.isInteger(this.nu) ? (double)Math2.minus1ToThe((int)this.nu) * this.f(-x) : Double.NaN;
            }
            if (x == 0.0) {
                return this.nu == 0.0 ? 1 : 0;
            }
            if (this.nu < 0.0 && Math.IEEEremainder(this.nu, 1.0) == 0.0) {
                return CylinderFunctions.getI(-this.nu).f(x);
            }
            return CylinderFunctions.I0to2(x, this.nu);
        }
    }

    static class _InC
    implements ComplexDoubleTransform {
        private double nu;

        _InC(double nu) {
            this.nu = nu;
        }

        @Override
        public ComplexDouble f(ComplexDouble z) {
            if (z.isZero()) {
                return this.nu == 0.0 ? ComplexDouble.ONE : ComplexDouble.ZERO;
            }
            if (z.isReal()) {
                if (z.realPart() > 0.0) {
                    return RectanglarComplexDouble.realValueOf(CylinderFunctions.getI(this.nu).f(z.realPart()));
                }
                if (Math2.isInteger(this.nu)) {
                    return RectanglarComplexDouble.realValueOf(CylinderFunctions.getI(this.nu).f(z.realPart()));
                }
            } else if (Math.abs(z.angle()) > 0.2 && Math.abs(z.angle()) < 2.94) {
                return CylinderFunctions.getJC(this.nu).f(ComplexDouble.I.multiply(z)).multiply(ComplexMath.expt(ComplexDouble.I, -this.nu));
            }
            if (this.nu < 0.0 && Math.IEEEremainder(this.nu, 1.0) == 0.0) {
                return CylinderFunctions.getIC(-this.nu).f(z);
            }
            return CylinderFunctions.I0to2(z, this.nu);
        }
    }

    static class _Jn
    implements DoubleTransform {
        private double nu;

        _Jn(double nu) {
            this.nu = nu;
        }

        @Override
        public double f(double x) {
            if (x < 0.0) {
                return Math2.isInteger(this.nu) ? (double)Math2.minus1ToThe((int)this.nu) * this.f(-x) : Double.NaN;
            }
            if (x == 0.0) {
                return this.nu == 0.0 ? 1 : 0;
            }
            if (x < Math.sqrt(this.nu + 1.0)) {
                return CylinderFunctions.bySeriesExpansion(x, this.nu, false);
            }
            if (this.nu < 0.0 && Math.IEEEremainder(this.nu, 1.0) == 0.0) {
                return (double)Math2.minus1ToThe((int)this.nu) * CylinderFunctions.getJ(-this.nu).f(x);
            }
            if (this.nu >= 0.0 && this.nu < 2.0) {
                return CylinderFunctions.J0to2(x, this.nu);
            }
            if (this.nu >= 2.0) {
                double w = Math2.decimalPart(this.nu);
                return CylinderFunctions.recurrenceJY(x, this.nu, CylinderFunctions.J0to2(x, w), CylinderFunctions.J0to2(x, w + 1.0));
            }
            int n = (int)Math.floor(this.nu);
            double w = Math2.decimalPart(this.nu);
            double j2 = 0.0;
            double j1 = CylinderFunctions.J0to2(x, w + 1.0);
            double r = CylinderFunctions.J0to2(x, w);
            int i = 0;
            while (i > n) {
                j2 = j1;
                j1 = r;
                r = j1 * (2.0 * ((double)i + w)) / x - j2;
                --i;
            }
            return r;
        }
    }

    static class _JnC
    implements ComplexDoubleTransform {
        private double nu;

        _JnC(double nu) {
            this.nu = nu;
        }

        @Override
        public ComplexDouble f(ComplexDouble z) {
            if (z.isZero()) {
                return this.nu == 0.0 ? ComplexDouble.ONE : ComplexDouble.ZERO;
            }
            if (z.isReal()) {
                if (z.realPart() > 0.0) {
                    return RectanglarComplexDouble.realValueOf(CylinderFunctions.getJ(this.nu).f(z.realPart()));
                }
                if (Math2.isInteger(this.nu)) {
                    return RectanglarComplexDouble.realValueOf(CylinderFunctions.getJ(this.nu).f(z.realPart()));
                }
            } else if (Math.abs(z.angle()) > 1.37 && Math.abs(z.angle()) < 1.77) {
                return CylinderFunctions.getIC(this.nu).f(z.divide(ComplexDouble.I)).multiply(ComplexMath.expt(ComplexDouble.I, this.nu));
            }
            if (z.abs() < Math.sqrt(this.nu + 1.0)) {
                return CylinderFunctions.bySeriesExpansion(z, this.nu, false);
            }
            if (this.nu < 0.0 && Math.IEEEremainder(this.nu, 1.0) == 0.0) {
                return (ComplexDouble)CylinderFunctions.getJC(-this.nu).f(z).multiply(Math2.minus1ToThe((int)this.nu));
            }
            if (this.nu >= 0.0 && this.nu < 2.0) {
                return CylinderFunctions.J0to2(z, this.nu);
            }
            if (this.nu >= 2.0) {
                double w = Math2.decimalPart(this.nu);
                return CylinderFunctions.recurrenceJY(z, this.nu, CylinderFunctions.J0to2(z, w), CylinderFunctions.J0to2(z, w + 1.0));
            }
            int n = (int)Math.floor(this.nu);
            double w = Math2.decimalPart(this.nu);
            ComplexDouble j2 = null;
            ComplexDouble j1 = CylinderFunctions.J0to2(z, w + 1.0);
            RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(CylinderFunctions.J0to2(z, w));
            int i = 0;
            while (i > n) {
                j2 = j1;
                j1 = r.toComplex();
                r.multiply(2.0 * ((double)i + w)).divide(z).subtract(j2);
                --i;
            }
            return r.toComplex();
        }
    }

    static class _JnD
    implements DoubleTransform {
        private double nu;

        _JnD(double nu) {
            this.nu = nu;
        }

        @Override
        public double f(double x) {
            return (CylinderFunctions.getJ(this.nu - 1.0).f(x) - CylinderFunctions.getJ(this.nu + 1.0).f(x)) / 2.0;
        }
    }

    static class _JnDC
    implements ComplexDoubleTransform {
        private double nu;

        _JnDC(double nu) {
            this.nu = nu;
        }

        @Override
        public ComplexDouble f(ComplexDouble z) {
            if (z.isReal() && z.realPart() > 0.0) {
                return RectanglarComplexDouble.realValueOf(CylinderFunctions.getDxJ(this.nu).f(z.realPart()));
            }
            RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(0.0, 0.0);
            r.add(CylinderFunctions.getJC(this.nu - 1.0).f(z));
            r.subtract(CylinderFunctions.getJC(this.nu + 1.0).f(z));
            r.divide(2.0);
            return r.toComplex();
        }
    }

    static class _Kn
    implements DoubleTransform {
        private double nu;

        _Kn(double nu) {
            this.nu = nu;
        }

        @Override
        public double f(double x) {
            if (this.nu < 0.0) {
                return CylinderFunctions.getK(-this.nu).f(x);
            }
            if (this.nu >= 2.0) {
                double w = Math2.decimalPart(this.nu);
                int n = (int)Math.floor(this.nu);
                double k1 = CylinderFunctions._K0to2(x, 0.0);
                double r = CylinderFunctions._K0to2(x, 1.0);
                int i = 2;
                while (i <= n) {
                    double k0 = k1;
                    k1 = r;
                    r = k0 + 2.0 * ((double)(i - 1) + w) / x * k1;
                    ++i;
                }
                return r;
            }
            return CylinderFunctions._K0to2(x, this.nu);
        }
    }

    static class _KnC
    implements ComplexDoubleTransform {
        private double nu;

        _KnC(double nu) {
            this.nu = nu;
        }

        @Override
        public ComplexDouble f(ComplexDouble z) {
            if (this.nu < 0.0) {
                return CylinderFunctions.getKC(-this.nu).f(z);
            }
            if (this.nu >= 2.0) {
                double w = Math2.decimalPart(this.nu);
                int n = (int)Math.floor(this.nu);
                ComplexDouble k1 = CylinderFunctions._K0to2(z, 0.0);
                ComplexDouble r = CylinderFunctions._K0to2(z, 1.0);
                int i = 2;
                while (i <= n) {
                    ComplexDouble k0 = k1;
                    k1 = r;
                    r = k0.add(k1.multiply(2.0 * ((double)(i - 1) + w)).divide(z));
                    ++i;
                }
                return r;
            }
            return CylinderFunctions._K0to2(z, this.nu);
        }
    }

    static class _Yn
    implements DoubleTransform {
        private double nu;

        _Yn(double nu) {
            this.nu = nu;
        }

        @Override
        public double f(double x) {
            if (Math2.isInteger(this.nu)) {
                if (this.nu >= 0.0 && this.nu <= 1.0) {
                    return CylinderFunctions.Y0to2(x, (int)this.nu);
                }
                if (this.nu >= 2.0) {
                    return CylinderFunctions.recurrenceJY(x, this.nu, CylinderFunctions.Y0to2(x, 0), CylinderFunctions.Y0to2(x, 1));
                }
                return (double)Math2.minus1ToThe((int)this.nu) * CylinderFunctions.getY(-this.nu).f(x);
            }
            return (CylinderFunctions.getJ(this.nu).f(x) * Math.cos(this.nu * Math.PI) - CylinderFunctions.getJ(-this.nu).f(x)) / Math.sin(this.nu * Math.PI);
        }
    }

    static class _YnC
    implements ComplexDoubleTransform {
        private double nu;

        _YnC(double nu) {
            this.nu = nu;
        }

        @Override
        public ComplexDouble f(ComplexDouble z) {
            if (z.isReal() && z.realPart() > 0.0) {
                return RectanglarComplexDouble.realValueOf(CylinderFunctions.getY(this.nu).f(z.realPart()));
            }
            if (Math2.isInteger(this.nu)) {
                if (this.nu >= 0.0 && this.nu <= 1.0) {
                    return CylinderFunctions.Y0to2(z, (int)this.nu);
                }
                if (this.nu >= 2.0) {
                    return CylinderFunctions.recurrenceJY(z, this.nu, CylinderFunctions.Y0to2(z, 0), CylinderFunctions.Y0to2(z, 1));
                }
                return (ComplexDouble)CylinderFunctions.getYC(-this.nu).f(z).multiply(Math2.minus1ToThe((int)this.nu));
            }
            RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(0.0, 0.0);
            r.add(CylinderFunctions.getJC(this.nu).f(z));
            r.multiply(Math.cos(this.nu * Math.PI));
            r.subtract(CylinderFunctions.getJC(-this.nu).f(z));
            r.divide(Math.sin(this.nu * Math.PI));
            return r.toComplex();
        }
    }
}

