/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.order;

import java.util.Collections;
import java.util.Set;
import net.morilib.math.order.OrderElement;

class LogarithmicOrder
extends OrderElement {
    int order;
    int level;

    LogarithmicOrder(int order, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException();
        }
        this.order = order;
        this.level = level;
    }

    @Override
    public int level() {
        return 72;
    }

    @Override
    public OrderElement multiply(OrderElement o) {
        if (this.level != ((LogarithmicOrder)o).level) {
            throw new IllegalArgumentException();
        }
        return new LogarithmicOrder(this.order + ((LogarithmicOrder)o).order, this.level);
    }

    @Override
    public Set<OrderElement> log() {
        return Collections.singleton(new LogarithmicOrder(1, this.level + 1));
    }

    @Override
    public int compareLevel(OrderElement o) {
        if (this.level() < o.level()) {
            return -1;
        }
        if (this.level() > o.level()) {
            return 1;
        }
        if (this.level < ((LogarithmicOrder)o).level) {
            return 1;
        }
        if (this.level > ((LogarithmicOrder)o).level) {
            return -1;
        }
        if (this.order < ((LogarithmicOrder)o).order) {
            return -1;
        }
        if (this.order > ((LogarithmicOrder)o).order) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(OrderElement o) {
        if (this.level() < o.level()) {
            return -1;
        }
        if (this.level() > o.level()) {
            return 1;
        }
        if (this.level < ((LogarithmicOrder)o).level) {
            return 1;
        }
        if (this.level > ((LogarithmicOrder)o).level) {
            return -1;
        }
        if (this.order < ((LogarithmicOrder)o).order) {
            return -1;
        }
        if (this.order > ((LogarithmicOrder)o).order) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isConstant() {
        return this.order == 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        int i = 0;
        while (i < this.level) {
            b.append("log ");
            ++i;
        }
        b.append("n)");
        if (this.order != 1) {
            b.append("^").append(this.order);
        }
        return b.toString();
    }
}

