/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.analysis.inexact;

import net.morilib.lang.transform.DoubleTransform;

public abstract class DoubleContinuedFractionFunction
implements DoubleTransform {
    protected double d = 0.0;
    protected double dh = 1.0;
    protected double h = 1.0;
    protected int n;

    protected abstract double getB0(double var1);

    protected abstract double getA1(double var1);

    protected abstract double getB1(double var1);

    protected abstract double getAn(int var1, double var2);

    protected abstract double getBn(int var1, double var2);

    protected double init(double x) {
        double b0 = this.getB0(x);
        double a1 = this.getA1(x);
        double b1 = this.getB1(x);
        this.d = 1.0 / b1;
        this.dh = a1 / b1;
        this.h = b0 + this.dh;
        this.n = 2;
        return this.h;
    }

    protected double next(double x) {
        double a = this.getAn(this.n, x);
        double b = this.getBn(this.n, x);
        this.d = 1.0 / (b + a * this.d);
        this.dh = (b * this.d - 1.0) * this.dh;
        this.h += this.dh;
        ++this.n;
        return this.h;
    }

    @Override
    public double f(double x) {
        double r = this.init(x);
        double s = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (!Double.isNaN(r) && r != s) {
            s = r;
            r = this.next(x);
            if (Double.isNaN(r)) {
                return Double.NaN;
            }
            ++i;
        }
        return r;
    }
}

