/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.io.Serializable;
import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousSignedArray;
import net.morilib.util.primitive.ShortArrayVector;
import net.morilib.util.uvector.ShortArray;

public class LispS16Vector
extends Atom
implements HomogeneousSignedArray,
Serializable {
    private ShortArray vector;

    private LispS16Vector() {
    }

    public LispS16Vector(short ... bs) {
        this.vector = ShortArray.newArray(bs);
    }

    public static LispS16Vector malloc(int size) {
        LispS16Vector res = new LispS16Vector();
        res.vector = ShortArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        if (!(d instanceof LispReal)) {
            return false;
        }
        return ((LispReal)d).inShortRange();
    }

    private static short[] toShortList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        ShortArrayVector v = new ShortArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispS16Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.s16", d);
            }
            v.add(d.getInt());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toShortArray();
    }

    @Override
    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#s16(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(this.vector.getShort(i));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String getResult() {
        return this.print();
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.print());
    }

    @Override
    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispS16Vector)) {
            return false;
        }
        if (!(d2 instanceof LispS16Vector)) {
            return false;
        }
        return ((LispS16Vector)d1).vector.equals(((LispS16Vector)d2).vector);
    }

    @Override
    public LispInteger get(int index) {
        return LispInteger.valueOf(this.vector.getInt(index));
    }

    @Override
    public void set(int index, LispReal x) {
        this.vector.setShort(index, x.castShort());
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispS16Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.s16", x);
        }
    }

    @Override
    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    @Override
    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    @Override
    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    public static class EqualS16Vector
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispS16Vector)) {
                throw mesg.getError("err.uvector.require.s16", c1a);
            }
            if (!(c2a instanceof LispS16Vector)) {
                throw mesg.getError("err.uvector.require.s16", c2a);
            }
            return LispBoolean.getInstance(((LispS16Vector)c1a).vector.equals(((LispS16Vector)c2a).vector));
        }
    }

    public static class IsS16Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispS16Vector);
        }
    }

    public static class ListToS16Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispS16Vector(LispS16Vector.toShortList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeS16Vector
    extends Subr {
        private short[] makeVector(int len, int d) {
            ShortArrayVector b = new ShortArrayVector();
            int i = 0;
            while (i < len) {
                b.add(d);
                ++i;
            }
            return b.toShortArray();
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispS16Vector(this.makeVector(t, 0));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispS16Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.s16", lst.get(1));
                }
                return new LispS16Vector(this.makeVector(t, lst.get(1).getInt()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class S16Vector
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispS16Vector(LispS16Vector.toShortList(body, mesg));
        }
    }

    public static class S16VectorToList
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispS16Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispS16Vector v = (LispS16Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(LispInteger.valueOf(v.vector.getShort(i)));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.s16", c1a);
        }
    }
}

