/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.io.Serializable;
import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispFloat;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousFloatArray;
import net.morilib.util.primitive.FloatArrayVector;
import net.morilib.util.uvector.FloatArray;

public class LispF32Vector
extends Atom
implements HomogeneousFloatArray,
Serializable {
    private FloatArray vector;

    private LispF32Vector() {
    }

    public LispF32Vector(float ... bs) {
        this.vector = FloatArray.newArray(bs);
    }

    public static LispF32Vector malloc(int size) {
        LispF32Vector res = new LispF32Vector();
        res.vector = FloatArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        return d instanceof LispReal;
    }

    private static float[] toFloatList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        FloatArrayVector v = new FloatArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispF32Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.f32", d);
            }
            v.add(Float.valueOf((float)d.getRealDouble()));
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toFloatArray();
    }

    @Override
    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#f32(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(this.vector.getFloat(i));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String getResult() {
        return this.print();
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.print());
    }

    @Override
    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispF32Vector)) {
            return false;
        }
        if (!(d2 instanceof LispF32Vector)) {
            return false;
        }
        return ((LispF32Vector)d1).vector.equals(((LispF32Vector)d2).vector);
    }

    @Override
    public LispFloat get(int index) {
        return new LispFloat(this.vector.getFloat(index));
    }

    @Override
    public void set(int index, LispReal x) {
        this.vector.setDouble(index, x.getRealDouble());
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispF32Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.f64", x);
        }
    }

    @Override
    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    @Override
    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    @Override
    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    public static class EqualF32Vector
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispF32Vector)) {
                throw mesg.getError("err.uvector.require.f32", c1a);
            }
            if (!(c2a instanceof LispF32Vector)) {
                throw mesg.getError("err.uvector.require.f32", c2a);
            }
            return LispBoolean.getInstance(((LispF32Vector)c1a).vector.equals(((LispF32Vector)c2a).vector));
        }
    }

    public static class F32Vector
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispF32Vector(LispF32Vector.toFloatList(body, mesg));
        }
    }

    public static class F32VectorToList
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispF32Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispF32Vector v = (LispF32Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(new LispFloat(v.vector.getFloat(i)));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.f32", c1a);
        }
    }

    public static class IsF32Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispF32Vector);
        }
    }

    public static class ListToF32Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispF32Vector(LispF32Vector.toFloatList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeF32Vector
    extends Subr {
        private float[] makeVector(int len, double d) {
            FloatArrayVector b = new FloatArrayVector();
            int i = 0;
            while (i < len) {
                b.add(Float.valueOf((float)d));
                ++i;
            }
            return b.toFloatArray();
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispF32Vector(this.makeVector(t, 0.0));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispF32Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.f32", lst.get(1));
                }
                return new LispF32Vector(this.makeVector(t, lst.get(1).getRealDouble()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }
}

