/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uuid;

import java.math.BigInteger;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uuid.LispUUID;

public class StringToUuid
extends UnaryArgs {
    private static final String PTNS = "([0-9A-Fa-f]{8})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{12})";
    private static final Pattern PTN = Pattern.compile("([0-9A-Fa-f]{8})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{12})");

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        String s = SubrUtils.getString(c1a, mesg);
        Matcher m = PTN.matcher(s);
        if (m.matches()) {
            String c = String.valueOf(m.group(1)) + m.group(2) + m.group(3) + m.group(4) + m.group(5);
            BigInteger b = new BigInteger(c, 16);
            return new LispUUID(new UUID(b.shiftRight(64).longValue(), b.longValue()));
        }
        throw mesg.getError("err.uuid.format.invalid", c1a);
    }
}

