/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.text;

import java.util.Map;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.text.LispHtmlElement;
import net.morilib.util.ArrayListStack;
import net.morilib.util.Strings;

public class TreeToString
extends UnaryArgs {
    @Override
    protected Datum execute(Datum tr, Environment env, LispMessage mesg) {
        ArrayListStack<Datum> stk = new ArrayListStack<Datum>();
        StringBuilder b = new StringBuilder();
        stk.push(tr);
        while (!stk.isEmpty()) {
            Datum d = (Datum)stk.pop();
            if (d instanceof Cons) {
                stk.push(((Cons)d).getCdr());
                stk.push(((Cons)d).getCar());
                continue;
            }
            if (d instanceof LispHtmlElement) {
                LispHtmlElement h = (LispHtmlElement)d;
                b.append("<");
                b.append(h.name);
                for (Map.Entry<String, String> e : h.attrs.entrySet()) {
                    String s = e.getValue();
                    b.append(" ");
                    b.append(e.getKey());
                    s = s.replaceAll("\"", "&quot;");
                    b.append("=\"");
                    b.append(s);
                    b.append("\"");
                }
                b.append(">");
                stk.push(new LispString("</" + h.name + "\n>"));
                if (h.content instanceof LispHtmlElement) {
                    stk.push(h.content);
                    continue;
                }
                stk.push(new LispString(Strings.escapeHtml(LispUtils.print(h.content))));
                continue;
            }
            if (d.isNil()) continue;
            b.append(LispUtils.print(d));
        }
        b.append("\n");
        return new LispString(b.toString());
    }
}

