/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.table;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;

public class MyTableModelListener
implements TableModelListener {
    static final Symbol INSERT = Symbol.getSymbol("insert");
    static final Symbol UPDATE = Symbol.getSymbol("update");
    static final Symbol DELETE = Symbol.getSymbol("delete");
    private Environment env;
    private Procedure proc;
    private LispMessage mesg;

    public MyTableModelListener(Environment env, Procedure proc, LispMessage mesg) {
        this.env = env;
        this.proc = proc;
        this.mesg = mesg;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() == -1) {
            Scheme.callva(this.proc, this.env, this.mesg, LispBoolean.FALSE, LispBoolean.FALSE, LispBoolean.FALSE, LispBoolean.FALSE);
        } else {
            LispInteger bg = LispInteger.valueOf(e.getFirstRow());
            LispInteger ed = LispInteger.valueOf(e.getLastRow());
            LispBoolean cl = e.getColumn() == -1 ? LispBoolean.FALSE : LispInteger.valueOf(e.getColumn());
            switch (e.getType()) {
                case 0: {
                    Scheme.callva(this.proc, this.env, this.mesg, bg, ed, cl, UPDATE);
                    return;
                }
                case 1: {
                    Scheme.callva(this.proc, this.env, this.mesg, bg, ed, cl, INSERT);
                    return;
                }
                case -1: {
                    Scheme.callva(this.proc, this.env, this.mesg, bg, ed, cl, DELETE);
                    return;
                }
            }
        }
    }
}

