/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.ILispVector;

public abstract class AbstractLispJListModel
extends Datum2
implements ListModel,
ILispVector {
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();

    public abstract Datum getElementAt(int var1);

    public Datum toList() {
        ConsListBuilder b = new ConsListBuilder();
        int i = 0;
        while (i < this.getSize()) {
            b.append(this.getElementAt(i));
            ++i;
        }
        return b.get();
    }

    @Override
    public int size() {
        return this.getSize();
    }

    @Override
    public Datum get(int index) {
        return this.getElementAt(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        ListDataEvent e = null;
        for (ListDataListener l : this.listeners) {
            if (e == null) {
                e = new ListDataEvent(source, 0, index0, index1);
            }
            l.contentsChanged(e);
        }
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        ListDataEvent e = null;
        for (ListDataListener l : this.listeners) {
            if (e == null) {
                e = new ListDataEvent(source, 1, index0, index1);
            }
            l.intervalAdded(e);
        }
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        ListDataEvent e = null;
        for (ListDataListener l : this.listeners) {
            if (e == null) {
                e = new ListDataEvent(source, 2, index0, index1);
            }
            l.intervalRemoved(e);
        }
    }

    public abstract boolean isEmpty();

    public abstract boolean contains(Object var1);

    public abstract Iterator<Datum> iterator();

    public abstract boolean add(Datum var1);

    public abstract boolean remove(Object var1);

    public abstract boolean containsAll(Collection<?> var1);

    public abstract boolean addAll(Collection<? extends Datum> var1);

    public abstract boolean addAll(int var1, Collection<? extends Datum> var2);

    public abstract boolean removeAll(Collection<?> var1);

    public abstract boolean retainAll(Collection<?> var1);

    public abstract void clear();

    public abstract Datum set(int var1, Datum var2);

    public abstract void add(int var1, Datum var2);

    public abstract Datum remove(int var1);

    public abstract int indexOf(Object var1);

    public abstract int lastIndexOf(Object var1);

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<jlist-model>");
    }
}

