/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.ILispButton;
import net.morilib.lisp.swing.LightweightGUIElement;
import net.morilib.lisp.swing.LispSwing;
import net.morilib.lisp.swing.listener.ActionListenable;

public class LispRadioButton
extends LightweightGUIElement
implements ILispButton,
ActionListenable {
    JRadioButton radio;

    public LispRadioButton(JRadioButton radio) {
        this.radio = radio;
    }

    @Override
    public Component getAWTComponent() {
        return this.radio;
    }

    @Override
    public AbstractButton getComponent() {
        return this.radio;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.radio.addActionListener(listener);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<radio-button>");
    }

    public static class MakeRadioButton
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            JRadioButton r;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 1) {
                String t = SubrUtils.getString(l.get(0), mesg);
                r = new JRadioButton(t);
            } else if (l.size() == 2) {
                String t = SubrUtils.getString(l.get(0), mesg);
                r = new JRadioButton(t);
                r.addActionListener(LispSwing.createActionListener(l.get(1), env, mesg));
            } else {
                throw mesg.getError("err.argument", body);
            }
            return new LispRadioButton(r);
        }
    }
}

