/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JDialog;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.lisp.swing.ILispComposite;
import net.morilib.lisp.swing.ILispDialog;
import net.morilib.lisp.swing.ILispWindow;

public class LispDialog
extends GUIElement
implements ILispComposite,
ILispDialog {
    private JDialog dialog;

    public LispDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public Container getPane() {
        return this.dialog.getContentPane();
    }

    @Override
    public void addWindowListener(WindowListener l) {
        this.dialog.addWindowListener(l);
    }

    @Override
    public Window getAWTWindow() {
        return this.dialog;
    }

    @Override
    public Component getAWTComponent() {
        return this.dialog;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<dialog>");
    }

    public static abstract class MakeDialog
    extends Subr {
        protected abstract boolean isModal();

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            JDialog res;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() != 4) {
                throw mesg.getError("err.argument", body);
            }
            Datum c1a = l.get(0);
            Datum c2a = l.get(1);
            int x = SubrUtils.getSmallInt(l.get(2), mesg);
            int y = SubrUtils.getSmallInt(l.get(3), mesg);
            if (!(c2a instanceof LispString)) throw mesg.getError("err.require.string", c2a);
            if (c1a instanceof ILispWindow) {
                res = new JDialog(((ILispWindow)((Object)c1a)).getFrame(), c2a.getString(), this.isModal());
            } else if (c1a instanceof ILispDialog) {
                res = new JDialog(((ILispDialog)((Object)c1a)).getDialog(), c2a.getString(), this.isModal());
            } else {
                if (c1a.isTrue()) throw mesg.getError("err.swing.require.parentframeordialog", c1a);
                res = new JDialog(null, c2a.getString(), this.isModal());
            }
            res.setSize(x, y);
            return new LispDialog(res);
        }
    }

    public static class MakeModalDialog
    extends MakeDialog {
        @Override
        protected boolean isModal() {
            return true;
        }
    }

    public static class MakeModelessDialog
    extends MakeDialog {
        @Override
        protected boolean isModal() {
            return false;
        }
    }
}

