/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import java.io.InputStream;
import net.morilib.lisp.r6rs.io.transcd.AbstractInputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispErrorHandlingMode;
import net.morilib.util.io.UTF8;

public class UTF8InputTranscoder
extends AbstractInputTranscoder {
    private InputStream ins;
    private LispErrorHandlingMode mode;

    public UTF8InputTranscoder(InputStream ins, LispErrorHandlingMode mode) {
        this.ins = ins;
        this.mode = mode;
    }

    @Override
    public int read() throws IOException {
        int r;
        int s;
        do {
            if ((r = UTF8.read(this.ins)) < 0) {
                return -1;
            }
            if (!Character.isDefined(r)) continue;
            return r;
        } while ((s = this.mode.ifRead(r, 65533)) < 0);
        return s;
    }

    @Override
    public void close() throws IOException {
        this.ins.close();
    }
}

