/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import net.morilib.lisp.r6rs.io.transcd.AbstractInputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispErrorHandlingMode;
import net.morilib.util.io.UTF16;

public class UTF16InputTranscoder
extends AbstractInputTranscoder {
    private PushbackInputStream ins;
    private LispErrorHandlingMode mode;
    private boolean endian;

    public UTF16InputTranscoder(InputStream ins, LispErrorHandlingMode mode) throws IOException {
        this.ins = new PushbackInputStream(ins, 2);
        this.mode = mode;
        int c1 = ins.read();
        int c2 = ins.read();
        int c = c1 << 8 | c2;
        if (c == 65279) {
            this.endian = true;
        } else if (c == 65534) {
            this.endian = false;
        } else {
            this.endian = true;
            this.ins.unread(c2);
            this.ins.unread(c1);
        }
    }

    @Override
    public int read() throws IOException {
        int r;
        int s;
        do {
            if ((r = UTF16.read(this.ins, this.endian)) < 0) {
                return -1;
            }
            if (!Character.isDefined(r)) continue;
            return r;
        } while ((s = this.mode.ifRead(r, 65533)) < 0);
        return s;
    }

    @Override
    public void close() throws IOException {
        this.ins.close();
    }
}

