/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import net.morilib.lisp.r6rs.io.transcd.InputTranscoder;
import net.morilib.util.io.UTF16;

public class StringInputTranscoder
implements InputTranscoder {
    private int[] str;
    private int ptr;

    public StringInputTranscoder(String str) {
        this.str = UTF16.getInts(str);
        this.ptr = 0;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        return this.ptr < this.str.length ? this.str[this.ptr++] : -1;
    }

    @Override
    public int read(int[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(int[] b, int off, int len) throws IOException {
        if (this.ptr < this.str.length) {
            int l = Math.min(len, this.str.length - this.ptr);
            System.arraycopy(this.str, this.ptr, b, off, l);
            this.ptr += l;
            return l;
        }
        return -1;
    }
}

