/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.r6rs.io.transcd.BlockBufferedOutputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LineBufferedOutputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.OutputTranscoder;

public abstract class LispBufferMode
extends Datum2 {
    public static final LispBufferMode NONE = new LispBufferMode("none"){

        @Override
        public OutputTranscoder getTranscoder(OutputTranscoder tr) {
            return tr;
        }

        @Override
        public OutputStream getOutputStream(OutputStream ous) {
            return ous;
        }
    };
    public static final LispBufferMode LINE = new LispBufferMode("line"){

        @Override
        public OutputTranscoder getTranscoder(OutputTranscoder tr) {
            return new LineBufferedOutputTranscoder(tr);
        }

        @Override
        public OutputStream getOutputStream(OutputStream ous) {
            return new BufferedOutputStream(ous);
        }
    };
    public static final LispBufferMode BLOCK = new LispBufferMode("block"){

        @Override
        public OutputTranscoder getTranscoder(OutputTranscoder tr) {
            return new BlockBufferedOutputTranscoder(tr);
        }

        @Override
        public OutputStream getOutputStream(OutputStream ous) {
            return new BufferedOutputStream(ous);
        }
    };
    private static final Symbol SYM_NONE = Symbol.getSymbol("none");
    private static final Symbol SYM_LINE = Symbol.getSymbol("line");
    private static final Symbol SYM_BLOCK = Symbol.getSymbol("block");
    private String symname;

    private LispBufferMode(String symname) {
        this.symname = symname;
    }

    public static LispBufferMode getInstance(Datum d) {
        if (d.equals(SYM_NONE)) {
            return NONE;
        }
        if (d.equals(SYM_LINE)) {
            return LINE;
        }
        if (d.equals(SYM_BLOCK)) {
            return BLOCK;
        }
        return null;
    }

    public abstract OutputTranscoder getTranscoder(OutputTranscoder var1);

    public abstract OutputStream getOutputStream(OutputStream var1);

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<file-option ").append(this.symname).append(">");
    }

    /* synthetic */ LispBufferMode(String string, LispBufferMode lispBufferMode) {
        this(string);
    }
}

