/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.r6rs.io.ILispTextualOutputPort;
import net.morilib.lisp.r6rs.io.LispCustomOutputPort;
import net.morilib.util.io.UTF16;

public class LispCustomTextualOutputPort
extends LispCustomOutputPort
implements ILispTextualOutputPort {
    private Procedure write;

    public LispCustomTextualOutputPort(Environment env, LispMessage mes, String id, Procedure wr, Procedure ps, Procedure sp, Procedure cl) {
        super(env, mes, id, ps, sp, cl);
        this.write = wr;
    }

    @Override
    public void putChar(int b) throws IOException {
        int[] c = new int[]{b};
        this.putString(UTF16.toString(c), 0, 1);
    }

    @Override
    public void putString(String src) throws IOException {
        this.putString(src, 0, src.length());
    }

    @Override
    public void putString(String src, int start) throws IOException {
        this.putString(src, start, src.length());
    }

    @Override
    public void putString(String s, int start, int end) throws IOException {
        LispString b = new LispString(s);
        Scheme.callva(this.write, this.env, this.mesg, b, LispInteger.valueOf(start), LispInteger.valueOf(end - start));
    }

    @Override
    public void putDatum(Datum d) throws IOException {
        this.putString(LispUtils.print(d));
    }
}

