/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.r6rs.io.ILispR6RSInputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;

public abstract class LispCustomInputPort
extends Datum2
implements ILispR6RSInputPort {
    private String id;
    Environment env;
    LispMessage mesg;
    private Procedure pos;
    private Procedure spos;
    private Procedure close;
    int lookahead;

    public LispCustomInputPort(Environment env, LispMessage mesg, String id, Procedure ps, Procedure sp, Procedure cl) {
        this.env = env;
        this.mesg = mesg;
        this.id = id;
        this.pos = ps;
        this.spos = sp;
        this.close = cl;
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return null;
    }

    @Override
    public boolean hasPortPosition() {
        return this.pos != null;
    }

    @Override
    public Datum getPortPosition() {
        if (this.pos != null) {
            return Scheme.callva(this.pos, this.env, this.mesg, new Datum[0]);
        }
        throw new LispNotSupportedException();
    }

    @Override
    public boolean hasSetPortPosition() {
        return this.spos != null;
    }

    @Override
    public void setPortPosition(Datum pos) {
        if (this.spos == null) {
            throw new LispNotSupportedException();
        }
        Scheme.callva(this.spos, this.env, this.mesg, pos);
    }

    @Override
    public void close() throws IOException {
        if (this.close != null) {
            Scheme.callva(this.close, this.env, this.mesg, new Datum[0]);
        }
    }

    @Override
    public boolean isPortEof() {
        return this.lookahead < 0;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<custom-binary-input-port ");
        buf.append(this.id).append(">");
    }
}

