/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.util.Iterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.Subr;
import net.morilib.lisp.painter.SchlushFont;
import net.morilib.lisp.util.ConsIterable;

public class DeriveFont
extends Subr {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        SchlushFont res;
        Iterator<Datum> d = new ConsIterable(body, mesg).iterator();
        if (!d.hasNext()) {
            throw mesg.getError("err.argument", body);
        }
        Datum c1a = d.next();
        if (!(c1a instanceof SchlushFont)) {
            throw mesg.getError("err.require.font", c1a);
        }
        Datum c2a = d.next();
        if (c2a instanceof SchlushFont.Style) {
            if (!d.hasNext()) {
                res = ((SchlushFont)c1a).deriveFont((SchlushFont.Style)c2a);
            } else {
                Datum c3a = d.next();
                if (!(c3a instanceof LispSmallInt)) throw mesg.getError("err.require.smallint", c3a);
                res = ((SchlushFont)c1a).deriveFont((SchlushFont.Style)c2a, c3a.getInt());
            }
        } else {
            if (!(c2a instanceof LispSmallInt)) throw mesg.getError("err.require.fontstyle", c2a);
            res = ((SchlushFont)c1a).deriveFont(c2a.getInt());
        }
        if (!d.hasNext()) return res;
        throw mesg.getError("err.argument", body);
    }
}

