/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.ntp;

import java.io.IOException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.datetime.LispDate;
import net.morilib.lisp.net.LispInetAddress;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.net.ntp.NTP;
import net.morilib.net.ntp.NTPException;
import net.morilib.net.ntp.NTPTimestamp;

public class NtpDate
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        int pt = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 123, mesg);
        try {
            NTPTimestamp t1;
            SubrUtils.checkTerminated(itr, body, mesg);
            if (d1 instanceof LispInetAddress) {
                t1 = NTP.receiveTime(((LispInetAddress)d1).getAddress(), pt);
            } else if (d1 instanceof LispString) {
                t1 = NTP.receiveTime(d1.getString(), pt);
            } else {
                throw mesg.getError("err.net.require.hostnameoraddress", d1);
            }
            return new LispDate(t1.getTime());
        }
        catch (NTPException e) {
            throw mesg.getError("err.net.ntp");
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }
}

