/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.geometry.g2d;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.geometry.g2d.ILispVector2D;
import net.morilib.lisp.math.matrix.ILispNumberVector;
import net.morilib.lisp.math.matrix.LispMatrixException;

public class LispF64Vector2D
extends Datum2
implements ILispVector2D {
    private double xp;
    private double yp;

    public LispF64Vector2D(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(x) || Double.isInfinite(y)) {
            throw new IllegalArgumentException();
        }
        this.xp = x;
        this.yp = y;
    }

    @Override
    public LispNumber get(int index) {
        switch (index) {
            case 0: {
                return new LispDouble(this.xp);
            }
            case 1: {
                return new LispDouble(this.yp);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void set(int index, LispNumber x) throws LispMatrixException {
        if (!x.isReal()) {
            throw new ClassCastException();
        }
        switch (index) {
            case 0: {
                this.xp = x.getRealDouble();
            }
            case 1: {
                this.yp = x.getRealDouble();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ILispNumberVector mul(LispNumber x) {
        if (x.isReal()) {
            double a = x.getRealDouble();
            return new LispF64Vector2D(this.xp * a, this.yp * a);
        }
        throw new ClassCastException();
    }

    @Override
    public ILispNumberVector add(ILispNumberVector v) {
        if (v.size() != 2) {
            throw new LispMatrixException();
        }
        if (!v.isRealVector()) {
            throw new ClassCastException();
        }
        return new LispF64Vector2D(this.xp + v.get(0).getRealDouble(), this.yp + v.get(1).getRealDouble());
    }

    @Override
    public ILispNumberVector sub(ILispNumberVector v) {
        if (v.size() != 2) {
            throw new LispMatrixException();
        }
        if (!v.isRealVector()) {
            throw new ClassCastException();
        }
        return new LispF64Vector2D(this.xp - v.get(0).getRealDouble(), this.yp - v.get(1).getRealDouble());
    }

    @Override
    public ILispNumberVector uminus() {
        return new LispF64Vector2D(-this.xp, -this.yp);
    }

    @Override
    public LispNumber innerProduct(ILispNumberVector v) {
        if (v.size() != 2) {
            throw new LispMatrixException();
        }
        if (!v.isRealVector()) {
            throw new ClassCastException();
        }
        return new LispDouble(this.xp * v.get(0).getRealDouble() + this.yp * v.get(1).getRealDouble());
    }

    @Override
    public LispNumber normSquared() {
        return new LispDouble(this.xp * this.xp + this.yp * this.yp);
    }

    @Override
    public boolean isEqualTo(ILispNumberVector v) {
        if (v.size() != 2) {
            return false;
        }
        if (!v.isRealVector()) {
            return false;
        }
        return this.xp == v.get(0).getRealDouble() && this.yp == v.get(1).getRealDouble();
    }

    @Override
    public boolean isQuaternionVector() {
        return true;
    }

    @Override
    public boolean isComplexVector() {
        return true;
    }

    @Override
    public boolean isRealVector() {
        return true;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public Iterator<LispNumber> iterator() {
        final double[] i = new double[]{this.xp, this.yp};
        return new Iterator<LispNumber>(){

            @Override
            public boolean hasNext() {
                return !Double.isNaN(i[1]);
            }

            @Override
            public LispNumber next() {
                double r;
                if (!Double.isNaN(i[0])) {
                    r = i[0];
                    i[0] = Double.NaN;
                } else if (!Double.isNaN(i[1])) {
                    r = i[1];
                    i[1] = Double.NaN;
                } else {
                    throw new NoSuchElementException();
                }
                return new LispDouble(r);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public LispNumber norm() {
        return new LispDouble(Math.sqrt(this.xp * this.xp + this.yp * this.yp));
    }

    @Override
    public LispReal crossProduct(ILispVector2D v) {
        if (v.size() != 2) {
            throw new LispMatrixException();
        }
        if (!v.isRealVector()) {
            throw new ClassCastException();
        }
        double xq = v.get(0).getRealDouble();
        double yq = v.get(1).getRealDouble();
        return new LispDouble(this.xp * yq - this.yp * xq);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#2Df(");
        buf.append(this.xp).append(" ");
        buf.append(this.yp).append(")");
    }
}

