/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.geometry.g2d;

import java.awt.geom.AffineTransform;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.geometry.g2d.ILispAffineTransform2D;
import net.morilib.lisp.math.matrix.AbstractImmutableLispMatrix;
import net.morilib.lisp.math.matrix.ILispMatrix;

public class LispDoubleAffineTransform2D
extends AbstractImmutableLispMatrix
implements ILispAffineTransform2D {
    public static final LispDoubleAffineTransform2D IDENTITY = new LispDoubleAffineTransform2D(1.0, 1.0, 0.0, 0.0, 0.0, 0.0);
    public static final LispDoubleAffineTransform2D REFLECTION_X = new LispDoubleAffineTransform2D(1.0, -1.0, 0.0, 0.0, 0.0, 0.0);
    public static final LispDoubleAffineTransform2D REFLECTION_Y = new LispDoubleAffineTransform2D(-1.0, 1.0, 0.0, 0.0, 0.0, 0.0);
    private double scaleX;
    private double scaleY;
    private double shearX;
    private double shearY;
    private double transX;
    private double transY;

    public LispDoubleAffineTransform2D(double scaleX, double scaleY, double shearX, double shearY, double translateX, double translateY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.shearX = shearX;
        this.shearY = shearY;
        this.transX = translateX;
        this.transY = translateY;
    }

    public static LispDoubleAffineTransform2D createRotateByRadian(double rad) {
        return new LispDoubleAffineTransform2D(Math.cos(rad), Math.cos(rad), Math.sin(rad), -Math.sin(rad), 0.0, 0.0);
    }

    public static LispDoubleAffineTransform2D createRotateByIntDegree(int deg) {
        switch (deg % 360) {
            case 0: {
                return IDENTITY;
            }
            case -270: 
            case 90: {
                return new LispDoubleAffineTransform2D(0.0, 0.0, 1.0, -1.0, 0.0, 0.0);
            }
            case -180: 
            case 180: {
                return new LispDoubleAffineTransform2D(-1.0, -1.0, 0.0, 0.0, 0.0, 0.0);
            }
            case -90: 
            case 270: {
                return new LispDoubleAffineTransform2D(0.0, 0.0, -1.0, 1.0, 0.0, 0.0);
            }
        }
        return LispDoubleAffineTransform2D.createRotateByRadian((double)deg * Math.PI / 180.0);
    }

    public static LispDoubleAffineTransform2D createScale(double sx, double sy) {
        return new LispDoubleAffineTransform2D(1.0 * sx, 1.0 * sy, 0.0, 0.0, 0.0, 0.0);
    }

    public static LispDoubleAffineTransform2D createShear(double sx, double sy) {
        return new LispDoubleAffineTransform2D(1.0, 1.0, sx, sy, 0.0, 0.0);
    }

    public static LispDoubleAffineTransform2D createTranslate(double tx, double ty) {
        return new LispDoubleAffineTransform2D(1.0, 1.0, 0.0, 0.0, tx, ty);
    }

    public static LispDoubleAffineTransform2D createSqueeze(double k) {
        return new LispDoubleAffineTransform2D(k, 1.0 / k, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public LispNumber get(int row, int column) {
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        return new LispDouble(this.scaleX);
                    }
                    case 1: {
                        return new LispDouble(this.shearX);
                    }
                    case 2: {
                        return new LispDouble(this.transX);
                    }
                }
                throw new IndexOutOfBoundsException();
            }
            case 1: {
                switch (column) {
                    case 0: {
                        return new LispDouble(this.shearY);
                    }
                    case 1: {
                        return new LispDouble(this.scaleY);
                    }
                    case 2: {
                        return new LispDouble(this.transY);
                    }
                }
                throw new IndexOutOfBoundsException();
            }
            case 2: {
                switch (column) {
                    case 0: 
                    case 1: {
                        return LispDouble.ZERO;
                    }
                    case 2: {
                        return LispDouble.ONE;
                    }
                }
                throw new IndexOutOfBoundsException();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int rowSize() {
        return 3;
    }

    @Override
    public int columnSize() {
        return 3;
    }

    @Override
    public LispReal getScaleX() {
        return new LispDouble(this.scaleX);
    }

    @Override
    public LispReal getScaleY() {
        return new LispDouble(this.scaleY);
    }

    @Override
    public LispReal getShearX() {
        return new LispDouble(this.shearX);
    }

    @Override
    public LispReal getShearY() {
        return new LispDouble(this.shearY);
    }

    @Override
    public LispReal getTranslateX() {
        return new LispDouble(this.transX);
    }

    @Override
    public LispReal getTranslateY() {
        return new LispDouble(this.transY);
    }

    @Override
    public double getScaleXDouble() {
        return this.scaleX;
    }

    @Override
    public double getScaleYDouble() {
        return this.scaleY;
    }

    @Override
    public double getShearXDouble() {
        return this.shearX;
    }

    @Override
    public double getShearYDouble() {
        return this.shearY;
    }

    @Override
    public double getTranslateXDouble() {
        return this.transX;
    }

    @Override
    public double getTranslateYDouble() {
        return this.transY;
    }

    @Override
    public AffineTransform toAWTTransform() {
        return new AffineTransform(this.scaleX, this.shearY, this.shearX, this.scaleY, this.transX, this.transY);
    }

    @Override
    public LispNumber determinant() {
        return new LispDouble(this.scaleX * this.scaleY - this.shearX * this.shearY);
    }

    @Override
    public ILispMatrix mul(ILispMatrix a) {
        if (a instanceof LispDoubleAffineTransform2D) {
            return this.concatenate((ILispAffineTransform2D)a);
        }
        return super.mul(a);
    }

    @Override
    public ILispMatrix adjoint() {
        return this;
    }

    @Override
    public ILispAffineTransform2D rotateByRadian(double rad) {
        return new LispDoubleAffineTransform2D(this.scaleX * Math.cos(rad) + this.shearX * -Math.sin(rad), this.shearY * Math.sin(rad) + this.scaleY * Math.cos(rad), this.scaleX * Math.sin(rad) + this.shearX * Math.cos(rad), this.shearY * Math.cos(rad) + this.scaleY * -Math.sin(rad), this.transX, this.transY);
    }

    @Override
    public ILispAffineTransform2D rotateByIntDegree(int deg) {
        switch (deg % 360) {
            case 0: {
                return this;
            }
            case -270: 
            case 90: {
                return new LispDoubleAffineTransform2D(-this.shearX, this.shearY, this.scaleX, -this.scaleY, this.transX, this.transY);
            }
            case -180: 
            case 180: {
                return new LispDoubleAffineTransform2D(-this.scaleX, -this.scaleY, -this.shearX, -this.shearY, this.transX, this.transY);
            }
            case -90: 
            case 270: {
                return new LispDoubleAffineTransform2D(this.shearX, -this.shearY, -this.scaleX, this.scaleY, this.transX, this.transY);
            }
        }
        return this.rotateByRadian((double)deg * Math.PI / 180.0);
    }

    @Override
    public ILispAffineTransform2D scale(double sx, double sy) {
        return new LispDoubleAffineTransform2D(this.scaleX * sx, this.scaleY * sy, this.shearX, this.shearY, this.transX, this.transY);
    }

    @Override
    public ILispAffineTransform2D shear(double sx, double sy) {
        return new LispDoubleAffineTransform2D(this.scaleX, this.scaleY, this.shearX * sx, this.shearY * sy, this.transX, this.transY);
    }

    @Override
    public ILispAffineTransform2D translate(double tx, double ty) {
        return new LispDoubleAffineTransform2D(this.scaleX, this.scaleY, this.shearX, this.shearY, this.transX + tx, this.transY + ty);
    }

    @Override
    public ILispAffineTransform2D reflectX() {
        return new LispDoubleAffineTransform2D(this.scaleX, -this.scaleY, this.shearX, this.shearY, this.transX, this.transY);
    }

    @Override
    public ILispAffineTransform2D reflectY() {
        return new LispDoubleAffineTransform2D(-this.scaleX, this.scaleY, this.shearX, this.shearY, this.transX, this.transY);
    }

    @Override
    public ILispAffineTransform2D squeeze(double k) {
        return new LispDoubleAffineTransform2D(this.scaleX * k, this.scaleY / k, this.shearX, this.shearY, this.transX, this.transY);
    }

    @Override
    public ILispAffineTransform2D concatenate(ILispAffineTransform2D t) {
        LispDoubleAffineTransform2D z = (LispDoubleAffineTransform2D)t;
        return new LispDoubleAffineTransform2D(this.scaleX * z.getScaleXDouble() + this.shearX * z.getShearYDouble(), this.shearY * z.getShearXDouble() + this.scaleY * z.getScaleYDouble(), this.scaleX * z.getShearXDouble() + this.shearX * z.getScaleYDouble(), this.shearY * z.getScaleXDouble() + this.scaleY * z.getShearYDouble(), this.scaleX * z.getTranslateXDouble() + this.shearX * z.getTranslateYDouble() + this.transX, this.shearY * z.getTranslateXDouble() + this.scaleY * z.getTranslateYDouble() + this.transY);
    }
}

