/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;

public class LispDatasource
extends Datum2 {
    DataSource source;
    private static final Map<Datum, String> SYM = new HashMap<Datum, String>();

    static {
        SYM.put(Symbol.getSymbol("applet"), "java.naming.applet");
        SYM.put(Symbol.getSymbol("authoritative"), "java.naming.authoritative");
        SYM.put(Symbol.getSymbol("batchsize"), "java.naming.batchsize");
        SYM.put(Symbol.getSymbol("dns-url"), "java.naming.dns.url");
        SYM.put(Symbol.getSymbol("initial-context-factory"), "java.naming.factory.initial");
        SYM.put(Symbol.getSymbol("language"), "java.naming.language");
        SYM.put(Symbol.getSymbol("object-factories"), "java.naming.factory.object");
        SYM.put(Symbol.getSymbol("provider-url"), "java.naming.provider.url");
        SYM.put(Symbol.getSymbol("referral"), "java.naming.referral");
        SYM.put(Symbol.getSymbol("security-authentication"), "java.naming.security.authentication");
        SYM.put(Symbol.getSymbol("security-credentials"), "java.naming.security.credentials");
        SYM.put(Symbol.getSymbol("security-principal"), "java.naming.security.principal");
        SYM.put(Symbol.getSymbol("security-protocol"), "java.naming.security.protocol");
        SYM.put(Symbol.getSymbol("state-factories"), "java.naming.factory.state");
        SYM.put(Symbol.getSymbol("url-pkg-prefixes"), "java.naming.factory.url.pkgs");
    }

    public LispDatasource(DataSource source) {
        this.source = source;
    }

    static Hashtable<?, ?> nextProp(Datum d, LispMessage m) {
        Properties r = System.getProperties();
        if (d == null) {
            return null;
        }
        ConsIterator itr = new ConsIterator(d);
        while (itr.hasNext()) {
            Datum d2 = itr.next();
            if (!(d2 instanceof Cons)) {
                throw m.getError("err.require.pair");
            }
            String t = SubrUtils.getString(((Cons)d2).getCdr(), m);
            String s = SYM.get(((Cons)d2).getCar());
            if (s == null) {
                s = SubrUtils.getString(((Cons)d2).getCar(), m);
            }
            r.put(s, t);
        }
        SubrUtils.checkProper(itr, d, m);
        return r;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<db-datasource>");
    }
}

