/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.exlib;

import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.UserException;
import net.morilib.lisp.format.DatumFormatArguments;
import net.morilib.lisp.format.FormatArguments;
import net.morilib.lisp.format.FormatArgumentsException;
import net.morilib.lisp.format.FormatParseException;
import net.morilib.lisp.format.LispFormat;
import net.morilib.lisp.format.LispFormatException;

public class LispError
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        Cons c1;
        if (body instanceof Cons && (c1 = (Cons)body).getCar().isTypeString()) {
            try {
                String fmt = c1.getCar().getString();
                String formatted = LispFormat.getInstance().format(fmt, (FormatArguments)new DatumFormatArguments(c1.getCdr()));
                throw new UserException(formatted);
            }
            catch (FormatArgumentsException e) {
                throw mesg.getError("err.srfi28.arguments.insufficient");
            }
            catch (FormatParseException e) {
                throw mesg.getError("err.srfi28.format.syntax");
            }
            catch (LispFormatException e) {
                throw mesg.getError("err.srfi28.format");
            }
        }
        throw mesg.getError("err.parameter.insufficient", "format");
    }
}

