/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.engineer.elec;

import net.morilib.lisp.Datum;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.graph.ILispEdge;
import net.morilib.lisp.graph.ILispGraph;
import net.morilib.lisp.graph.ILispVertex;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.LispMatrix;
import net.morilib.util.mapset.HashOneToOneSet;

public class Circuits {
    private static final Symbol EQ = Symbol.getSymbol("=");

    /*
     * WARNING - void declaration
     */
    public static ILispMatrix toCircuitMatrix(ILispGraph g, LispMessage mesg) {
        ILispVertex d;
        void var6_10;
        int ii = 0;
        HashOneToOneSet<Integer, Datum> mp = new HashOneToOneSet<Integer, Datum>();
        for (Datum datum : g.getVertexNames()) {
            if (!datum.isTrue()) continue;
            mp.put(ii++, datum);
        }
        LispMatrix m = new LispMatrix(mp.size(), mp.size());
        boolean bl = false;
        while (var6_10 < mp.size()) {
            d = g.getVertex((Datum)mp.getValue((int)var6_10));
            for (ILispEdge iLispEdge : d.getEdges()) {
                LispNumber n;
                if (EQ.equals(iLispEdge.getLabel())) {
                    Integer j = (Integer)mp.getKey(g.getDatum(iLispEdge.getTerminal()));
                    if (j == null) {
                        throw mesg.getError("err.circuit.graph.invalid");
                    }
                    m.set((int)var6_10, j, LispInteger.valueOf(-1));
                    m.set(j, (int)var6_10, LispInteger.valueOf(1));
                    continue;
                }
                if (!(iLispEdge.getLabel() instanceof LispNumber)) {
                    throw mesg.getError("err.require.number", iLispEdge.getLabel());
                }
                if (g.getDatum(iLispEdge.getTerminal()).isTrue()) {
                    n = (LispNumber)iLispEdge.getLabel();
                    int j = (Integer)mp.getKey(g.getDatum(iLispEdge.getTerminal()));
                    m.set((int)var6_10, (int)var6_10, m.get((int)var6_10, (int)var6_10).add(n));
                    m.set(j, j, m.get(j, j).add(n));
                    m.set((int)var6_10, j, m.get((int)var6_10, j).sub(n));
                    m.set(j, (int)var6_10, m.get(j, (int)var6_10).sub(n));
                    continue;
                }
                n = (LispNumber)iLispEdge.getLabel();
                m.set((int)var6_10, (int)var6_10, m.get((int)var6_10, (int)var6_10).add(n));
            }
            ++var6_10;
        }
        d = g.getVertex(LispBoolean.FALSE);
        for (ILispEdge iLispEdge : d.getEdges()) {
            if (EQ.equals(iLispEdge.getLabel())) {
                throw mesg.getError("err.circuit.graph.invalid");
            }
            if (!(iLispEdge.getLabel() instanceof LispNumber)) {
                throw mesg.getError("err.require.number", iLispEdge.getLabel());
            }
            LispNumber n = (LispNumber)iLispEdge.getLabel();
            int j = (Integer)mp.getKey(g.getDatum(iLispEdge.getTerminal()));
            m.set(j, j, m.get(j, j).add(n));
        }
        return m;
    }
}

