/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.morilib.diff.Diff;
import net.morilib.diff.Patch;
import net.morilib.lang.EqualPredicate;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.diff.LispPatch;
import net.morilib.lisp.subr.SubrUtils;

public class MakePatch
extends Subr {
    static final EqualPredicate DEF_EQ = new EqualPredicate(){

        @Override
        public boolean isEqual(Object a, Object b) {
            return a != null ? a.equals(b) : b == null;
        }
    };

    private List<Datum> tolist(Datum a) {
        ArrayList<Datum> r = new ArrayList<Datum>();
        ConsIterator i = new ConsIterator(a);
        while (i.hasNext()) {
            r.add(i.next());
        }
        return r;
    }

    @Override
    public Datum eval(Datum body, final Environment env, final LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum b = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        final Procedure p = SubrUtils.nextProcedureOptional(itr, mesg);
        SubrUtils.checkTerminated(itr, body, mesg);
        List<Datum> al = this.tolist(a);
        List<Datum> bl = this.tolist(b);
        EqualPredicate eq = p == null ? DEF_EQ : new EqualPredicate(){

            @Override
            public boolean isEqual(Object a, Object b) {
                return Scheme.callva(p, env, mesg, (Datum)a, (Datum)b).isTrue();
            }
        };
        Patch<Datum> r = Diff.patch(al, bl, eq);
        return new LispPatch(r);
    }
}

