/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.compare;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.compare.SRFI67;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class VectorCompare
extends Subr {
    Datum comparevec(ILispVector x, ILispVector y, Datum p, Datum s, Datum r, Environment env, LispMessage mesg) {
        int sy;
        int sx = SRFI67.callSize(s, x, env, mesg);
        if (sx < (sy = SRFI67.callSize(s, y, env, mesg))) {
            return SRFI67.LESS;
        }
        if (sx > sy) {
            return SRFI67.GREATER;
        }
        int i = 0;
        while (i < sx) {
            Datum y0;
            Datum x0 = SRFI67.callRef(r, x, i, env, mesg);
            LispInteger c = SRFI67.callCompare(p, x0, y0 = SRFI67.callRef(r, y, i, env, mesg), env, mesg);
            if (c.signum() != 0) {
                return c;
            }
            ++i;
        }
        return SRFI67.EQUAL;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        Datum y;
        Datum x;
        ConsIterator itr = new ConsIterator(body);
        Datum x1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum p = null;
        Datum s = null;
        Datum r = null;
        if (x1 instanceof Procedure) {
            p = x1;
            x = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            y = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            s = Iterators.nextIf(itr);
            if (s != null) {
                r = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            }
        } else {
            x = x1;
            y = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            s = Iterators.nextIf(itr);
            if (s != null) {
                r = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            }
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(x instanceof ILispVector)) {
            throw mesg.getError("err.require.vector", x);
        }
        if (!(y instanceof LispVector)) {
            throw mesg.getError("err.require.vector", y);
        }
        return this.comparevec((ILispVector)((Object)x), (ILispVector)((Object)y), p, s, r, env, mesg);
    }
}

