/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import net.morilib.lisp.Datum;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispPurelyMutableCollection;
import net.morilib.lisp.collection.LispSet;
import net.morilib.lisp.collection.LispSetDatum;
import net.morilib.lisp.collection.LispSortedSetDatum;
import net.morilib.lisp.collection.NoBoundsException;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispUnion;

public abstract class LispMutableSortedSetDatum
extends LispSortedSetDatum
implements LispPurelyMutableCollection {
    @Override
    public abstract LispMutableSortedSetDatum prototype();

    @Override
    public abstract LispMutableSortedSetDatum duplicate();

    @Override
    public abstract Datum add(Datum var1);

    @Override
    public abstract Datum delete(Datum var1);

    @Override
    public abstract LispSetDatum intersection(LispSet var1);

    @Override
    public LispSetDatum addAll(LispSet s) {
        try {
            return super.addAll(s);
        }
        catch (ImmutableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LispSetDatum removeAll(LispSet s) {
        try {
            return super.removeAll(s);
        }
        catch (ImmutableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Datum symmetricDifferenceModify(LispSet s) {
        try {
            return super.symmetricDifferenceModify(s);
        }
        catch (ImmutableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Datum addFrom(LispBag s) {
        try {
            return super.addFrom(s);
        }
        catch (ImmutableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Datum deleteFrom(LispBag s) {
        try {
            return super.deleteFrom(s);
        }
        catch (ImmutableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Datum copyAdd(Datum d) {
        return this.duplicate().add(d);
    }

    @Override
    public Datum copyDelete(Datum d) {
        return this.duplicate().delete(d);
    }

    @Override
    public LispSetDatum union(LispSet s) {
        return this.duplicate().addAll(s);
    }

    @Override
    public Datum difference(LispSet s) {
        return this.duplicate().removeAll(s);
    }

    @Override
    public Datum symmetricDifference(LispSet s) {
        return this.duplicate().symmetricDifferenceModify(s);
    }

    @Override
    public Datum copyAddFrom(LispBag d) {
        return this.duplicate().addFrom(d);
    }

    @Override
    public Datum copyDeleteFrom(LispBag d) {
        return this.duplicate().deleteFrom(d);
    }

    @Override
    public Datum removeFirst() throws NoBoundsException {
        try {
            return super.removeFirst();
        }
        catch (ImmutableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Datum removeLast() throws NoBoundsException {
        try {
            return super.removeLast();
        }
        catch (ImmutableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Datum copyWithoutFirst() throws NoBoundsException {
        return this.duplicate().removeFirst();
    }

    @Override
    public Datum copyWithoutLast() throws NoBoundsException {
        return this.duplicate().removeLast();
    }

    @Override
    public ILispTopology unionTopology(ILispTopology t) {
        if (t instanceof LispSet) {
            return this.union((LispSet)t);
        }
        if (t.isEmpty()) {
            return this;
        }
        if (t.isUniverse()) {
            return t;
        }
        return LispUnion.newInstance(this, t);
    }

    @Override
    public ILispTopology intersectionTopology(ILispTopology t) {
        if (t instanceof LispSet) {
            return this.intersection((LispSet)t);
        }
        if (t.isEmpty()) {
            return this;
        }
        if (t.isUniverse()) {
            return t;
        }
        return LispUnion.newInstance(this, t);
    }
}

