/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.awt.cursor;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.Datum2;

public class LispCursor
extends Datum2 {
    private static final Map<String, LispCursor> TYPES = new HashMap<String, LispCursor>();
    Cursor cursor;

    static {
        TYPES.put("crosshair-cursor", LispCursor.getInstance(1));
        TYPES.put("default-cursor", LispCursor.getInstance(0));
        TYPES.put("e-resize-cursor", LispCursor.getInstance(11));
        TYPES.put("hand-cursor", LispCursor.getInstance(12));
        TYPES.put("move-cursor", LispCursor.getInstance(13));
        TYPES.put("n-resize-cursor", LispCursor.getInstance(8));
        TYPES.put("ne-resize-cursor", LispCursor.getInstance(7));
        TYPES.put("nw-resize-cursor", LispCursor.getInstance(6));
        TYPES.put("s-resize-cursor", LispCursor.getInstance(9));
        TYPES.put("se-resize-cursor", LispCursor.getInstance(5));
        TYPES.put("sw-resize-cursor", LispCursor.getInstance(4));
        TYPES.put("text-cursor", LispCursor.getInstance(2));
        TYPES.put("w-resize-cursor", LispCursor.getInstance(10));
        TYPES.put("wait-cursor", LispCursor.getInstance(3));
    }

    protected LispCursor(Cursor c) {
        this.cursor = c;
    }

    public static LispCursor getInstance(int type) {
        return new LispCursor(Cursor.getPredefinedCursor(type));
    }

    public static LispCursor getInstance(String s) throws HeadlessException, AWTException {
        LispCursor c = TYPES.get(s);
        if (c != null) {
            return c;
        }
        return new LispCursor(Cursor.getSystemCustomCursor(s));
    }

    public static LispCursor getDefault() {
        return new LispCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<cursor ").append(this.cursor).append(">");
    }
}

