/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.awt.cursor;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.HeadlessException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.awt.cursor.LispCursor;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.util.Iterators;

public class CursorSetS
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = Iterators.nextIf(itr);
        SubrUtils.checkTerminated(itr, body, mesg);
        try {
            LispCursor lc;
            if (!(c1a instanceof GUIElement)) {
                throw mesg.getError("err.swing.require.guielement", c1a);
            }
            if (c2a == null) {
                lc = LispCursor.getDefault();
            } else if (c2a instanceof LispString) {
                lc = LispCursor.getInstance(c2a.getString());
            } else if (c2a instanceof Symbol) {
                lc = LispCursor.getInstance(((Symbol)c2a).getName());
            } else {
                throw mesg.getError("err.require.symbol", c2a);
            }
            Component c = ((GUIElement)c1a).getAWTComponent();
            c.setCursor(lc.cursor);
            return LispBoolean.TRUE;
        }
        catch (HeadlessException e) {
            return LispBoolean.FALSE;
        }
        catch (AWTException e) {
            return LispBoolean.FALSE;
        }
    }
}

