/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.PatternMatch;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.SynLetType;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.Undef;

public class SynLet
extends Syntax
implements SynLetType {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (body instanceof Cons) {
            CompiledCode.Builder nbuild = new CompiledCode.Builder();
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            ArrayList<Datum> lvars = new ArrayList<Datum>();
            ArrayList<Datum> lvals = new ArrayList<Datum>();
            Cons bnam = new Cons();
            Environment nenv = new Environment(env);
            ClosureClass cl = new ClosureClass();
            if (bcar instanceof SymbolName) {
                bnam.setCar(bcar);
                nbuild.addPush(cl);
                nbuild.addBind(bcar);
                if (bcdr instanceof Cons) {
                    bcar = ((Cons)bcdr).getCar();
                    bcdr = ((Cons)bcdr).getCdr();
                } else {
                    throw mesg.getError("err.let.malform");
                }
            }
            if (bcar instanceof Cons) {
                Datum d = bcar;
                while (d != Nil.NIL) {
                    if (d instanceof Cons) {
                        List<Datum> l2 = LispUtils.consToList(((Cons)d).getCar(), mesg);
                        if (l2.size() != 2) {
                            throw mesg.getError("err.let.malform");
                        }
                        if (!(l2.get(0) instanceof SymbolName)) {
                            throw mesg.getError("err.let.malform");
                        }
                        lvars.add(l2.get(0));
                        lvals.add(l2.get(1));
                        nenv.bindDatumWithoutScope(l2.get(0), Undef.UNDEF2);
                        d = ((Cons)d).getCdr();
                        continue;
                    }
                    throw mesg.getError("err.let.malform");
                }
            } else if (bcar != Nil.NIL) {
                throw mesg.getError("err.let.malform");
            }
            bnam.setCdr(LispUtils.listToCons(lvars));
            if (bnam.getCar() == Nil.NIL) {
                symlist.add(callsym);
                SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, bnam, istail, mesg, symlist, exec, memento, syncased);
                symlist.remove(0);
            } else {
                SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, bnam, true, mesg, new ArrayList<Cons>(), exec, memento, syncased);
            }
            nbuild.addReturnOp();
            cl.setParameterList(LispUtils.listToCons(lvars));
            cl.setCode(nbuild.getCodeRef());
            build.addPush(cl);
            comp.compileArgs(LispUtils.listToCons(lvals), env, build, callsym, symlist, exec, memento, syncased);
            if (bnam.getCar() != Nil.NIL && istail) {
                build.addCallTail(symlist.size());
            } else {
                build.addCall();
            }
        } else {
            throw mesg.getError("err.let.malform");
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            ArrayList<Datum> lst = new ArrayList<Datum>();
            Environment nenv = new Environment(ienv);
            if (bcar instanceof SymbolName) {
                lst.add(SyntaxUtils.putSymbol(nenv, bcar, mesg));
                if (bcdr instanceof Cons) {
                    bcar = ((Cons)bcdr).getCar();
                    bcdr = ((Cons)bcdr).getCdr();
                } else {
                    throw mesg.getError("err.let.malform");
                }
            }
            ArrayList<Cons> lst2 = new ArrayList<Cons>();
            if (bcar instanceof Cons) {
                Datum d = bcar;
                while (d != Nil.NIL) {
                    if (d instanceof Cons) {
                        Cons rc = new Cons();
                        Cons r2 = new Cons();
                        rc.setCdr(r2);
                        List<Datum> l2 = LispUtils.consToList(((Cons)d).getCar(), mesg);
                        if (l2.size() != 2) {
                            throw mesg.getError("err.let.malform");
                        }
                        if (l2.get(0) instanceof SymbolName || l2.get(0) instanceof PatternMatch.IndSym) {
                            rc.setCar(SyntaxUtils.putSymbol(nenv, l2.get(0), mesg));
                        }
                        r2.setCar(comp.replaceLocalVals(l2.get(1), env, ienv, false, ttype));
                        d = ((Cons)d).getCdr();
                        lst2.add(rc);
                        continue;
                    }
                    throw mesg.getError("err.let.malform");
                }
            } else if (bcar != Nil.NIL) {
                throw mesg.getError("err.let.malform");
            }
            lst.add(LispUtils.listToCons(lst2));
            Datum cdrx = SyntaxUtils.replaceLocalValsList(bcdr, env, comp, nenv, mesg, ttype);
            return LispUtils.listToCons(lst, cdrx);
        }
        throw mesg.getError("err.let.malform");
    }
}

