/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.morilib.lisp.Closure;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CodeExecutorFactory;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.IOs;

public final class LispFeature {
    private static final BinaryArgs _ADD_FEATURE = new _AddFeature();
    private static final String RESOURCE = "/net/morilib/lisp/exlib/srfi-7.scm";
    private static final String MAIN = "eval-srfi-7";
    private static final String SRFI7_VALID = "*srfi-7-valid*";
    private static final Symbol SRFI7_VALID_SYM = Symbol.getSymbol("*srfi-7-valid*");
    private static Scheme srfi7Lang;
    private static ConcurrentHashMap<Datum, CompiledCode> features;
    private static ConcurrentHashMap<Datum, Boolean> loaded;

    static {
        features = new ConcurrentHashMap();
        loaded = new ConcurrentHashMap();
    }

    private static boolean applyFeature(Datum c1a, Environment env, LispMessage mesg) {
        CompiledCode cd = features.get(c1a);
        if (loaded.containsKey(c1a)) {
            return true;
        }
        if (cd != null) {
            CodeExecutor exe = CodeExecutorFactory.getInstance(mesg);
            exe.exec(cd, env, exe.newMemento());
            loaded.put(c1a, Boolean.TRUE);
            return true;
        }
        return false;
    }

    private static void initSRFI7() {
        InputStream ins = null;
        BufferedReader rd = null;
        try {
            try {
                srfi7Lang = Scheme.newEmpty();
                srfi7Lang.loadRnRS(5);
                ins = LispFeature.class.getResourceAsStream(RESOURCE);
                rd = new BufferedReader(new InputStreamReader(ins));
                srfi7Lang.readFile(rd);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            IOs.close(ins);
            throw throwable;
        }
        IOs.close(ins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Datum evalSRFI7(Datum pgm, Environment env, LispMessage mesg) {
        try {
            Datum d = env.findDatum(SRFI7_VALID_SYM);
            if (d == null || !d.isTrue()) {
                return pgm;
            }
            if (srfi7Lang != null) return srfi7Lang.call(MAIN, pgm);
            Class<LispFeature> clazz = LispFeature.class;
            synchronized (LispFeature.class) {
                LispFeature.initSRFI7();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return srfi7Lang.call(MAIN, pgm);
            }
        }
        catch (LispException e) {
            throw mesg.getError("err.srfi7.invalid");
        }
    }

    public static class ApplyFeature
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(LispFeature.applyFeature(c1a, env, mesg));
        }
    }

    public static class ApplyFeatures
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            boolean r = true;
            if (c1a.isNil()) {
                return LispBoolean.TRUE;
            }
            if (c1a instanceof Cons) {
                ConsIterator itr = new ConsIterator(c1a);
                while (itr.hasNext()) {
                    r = LispFeature.applyFeature(itr.next(), env, mesg) | r;
                }
                return LispBoolean.getInstance(r);
            }
            return LispBoolean.getInstance(LispFeature.applyFeature(c1a, env, mesg));
        }
    }

    public static class FeatureAnd
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            HashSet<Datum> set = new HashSet<Datum>();
            while (itr.hasNext()) {
                Datum d = itr.next();
                if (!d.isTrue()) {
                    return LispBoolean.FALSE;
                }
                if (d instanceof Cons || d.isNil()) {
                    set.addAll(LispUtils.consToList(d, mesg));
                    continue;
                }
                if (features.containsKey(d)) {
                    set.add(d);
                    continue;
                }
                return LispBoolean.FALSE;
            }
            return LispUtils.toCons(set);
        }
    }

    public static class FeatureNot
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return features.containsKey(c1a) ? LispBoolean.FALSE : Nil.NIL;
        }
    }

    public static class FeatureOr
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            HashSet<Datum> set = new HashSet<Datum>();
            while (itr.hasNext()) {
                Datum d = itr.next();
                if (!d.isTrue()) continue;
                if (d instanceof Cons || d.isNil()) {
                    set.addAll(LispUtils.consToList(d, mesg));
                    continue;
                }
                if (!features.containsKey(d)) continue;
                set.add(d);
            }
            return LispUtils.toCons(set);
        }
    }

    public static class IsFeatureExist
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(features.containsKey(c1a));
        }
    }

    public static class SynDefineFeature
    extends Syntax {
        @Override
        void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
            CompiledCode.Builder nbuild = new CompiledCode.Builder();
            Environment nenv = new Environment(env);
            ClosureClass cl = new ClosureClass();
            ConsIterator itr = new ConsIterator(body);
            Datum sym = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (!toplevel) {
                throw mesg.getError("err.nottoplevel");
            }
            if (!(sym instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", sym);
            }
            SyntaxUtils.compileList(itr.rest(), nenv, comp, nbuild, callsym, false, mesg, symlist, exec, memento, syncased);
            cl.setParameterList(Nil.NIL);
            cl.setCode(nbuild.getCodeRef());
            build.addPush(_ADD_FEATURE);
            build.addBeginList();
            build.addPush(sym);
            build.addAppendList();
            build.addPush(cl);
            build.addAppendList();
            build.addEndList();
            build.addCall();
        }

        @Override
        Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
            throw mesg.getError("err.define.definesyntax");
        }
    }

    private static class _AddFeature
    extends BinaryArgs {
        private _AddFeature() {
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            features.put(c1a, ((Closure)c2a).getCode());
            return Undef.UNDEF;
        }
    }
}

