/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import net.morilib.lang.Decimal32;
import net.morilib.lang.Decimal64;
import net.morilib.lang.DoubleUtils;
import net.morilib.lang.number.AbstractNumericalField;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalField;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispAlternatingSeriesNumber;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDecimal32;
import net.morilib.lisp.LispDecimal64;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispFloat;
import net.morilib.lisp.LispHalf;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispIrrational;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispRangedDouble;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.sos.LispType;

public abstract class LispExactReal
extends LispReal {
    private static final NumericalField<LispReal> _FIELDR = new AbstractNumericalField<LispReal>(){

        @Override
        public LispReal valueOf(float v) {
            return LispDouble.toExact(v);
        }

        @Override
        public LispReal valueOf(double v) {
            return LispDouble.toExact(v);
        }

        @Override
        public LispReal valueOf(BigDecimal v) {
            return LispUtils.bigDecimalToRational(v);
        }

        @Override
        public LispReal valueOf(Rational v) {
            return LispRational.valueOf(v);
        }

        @Override
        public LispReal valueOf(int v) {
            return LispInteger.valueOf(v);
        }

        @Override
        public LispReal valueOf(long v) {
            return LispInteger.valueOf(v);
        }

        @Override
        public LispReal valueOf(Integer2 v) {
            return LispInteger.valueOf(v.toBigInteger());
        }

        @Override
        public LispReal getUnit() {
            return LispInteger.ONE;
        }

        @Override
        public LispReal getZero() {
            return LispInteger.ZERO;
        }
    };

    public abstract Rational toRational();

    @Override
    public abstract LispExactReal uminus();

    @Override
    public LispExactReal toExact() {
        return this;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isInfinity() {
        return false;
    }

    @Override
    public LispType getType() {
        return LispType.REAL;
    }

    @Override
    public LispReal multiply(int n) {
        return this.multiply(new LispSmallInt(n));
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public LispReal power(int n) {
        if (n < 0) {
            return (LispReal)this.power(-n).invert();
        }
        if (n == 0) {
            return LispInteger.ONE;
        }
        if (n == 1) {
            return this;
        }
        LispReal r = this;
        int i = 1;
        while (i < n) {
            r = r.multiply(this);
            ++i;
        }
        return r;
    }

    @Override
    public NumericalField<LispReal> getUniverse() {
        return _FIELDR;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble(this.doubleValue() + x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispHalf(DoubleUtils.toHalf(this.doubleValue() + x.getRealDouble()));
        }
        if (x instanceof LispFloat) {
            return new LispFloat(this.floatValue() + x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble(this.doubleValue() + x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.add(this.getRealDecimal32(), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.add(this.getRealDecimal64(), x.getRealDecimal64()));
        }
        if (x instanceof LispAlternatingSeriesNumber) {
            return x.add(this);
        }
        if (x instanceof LispIrrational) {
            return new LispDouble(this.doubleValue() + x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.add(c.getReal()), c.getImag());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.add(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.add(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble(this.doubleValue() - x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispHalf(DoubleUtils.toHalf(this.doubleValue() - x.getRealDouble()));
        }
        if (x instanceof LispFloat) {
            return new LispFloat(this.floatValue() - x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble(this.doubleValue() - x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.subtract(this.getRealDecimal32(), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.subtract(this.getRealDecimal64(), x.getRealDecimal64()));
        }
        if (x instanceof LispAlternatingSeriesNumber) {
            return ((LispAlternatingSeriesNumber)x).negate().add(this);
        }
        if (x instanceof LispIrrational) {
            return new LispDouble(this.doubleValue() - x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.subtract(c.getReal()), c.getImag().uminus());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.sub(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.sub(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return LispRangedDouble.valueOf(this.doubleValue() * x.getRealDouble(), this.doubleValue() * ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispHalf(DoubleUtils.toHalf(this.doubleValue() * x.getRealDouble()));
        }
        if (x instanceof LispFloat) {
            return new LispFloat(this.floatValue() * x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble(this.doubleValue() * x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.multiply(this.getRealDecimal32(), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.multiply(this.getRealDecimal64(), x.getRealDecimal64()));
        }
        if (x instanceof LispAlternatingSeriesNumber) {
            return x.mul(this);
        }
        if (x instanceof LispIrrational) {
            return new LispDouble(this.doubleValue() * x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.multiply(c.getReal()), this.multiply(c.getImag()));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.mul(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.mul(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            LispRangedDouble x0 = (LispRangedDouble)x;
            if (x0.isZeroIncluded()) {
                return LispDouble.NaN;
            }
            double y1 = this.doubleValue() / x0.getRealDouble() + this.doubleValue() * x0.error;
            double y2 = this.doubleValue() / x0.getRealDouble() - this.doubleValue() * x0.error;
            return LispRangedDouble.valueOf((y1 + y2) / 2.0, Math.abs(y1 - y2) / 2.0);
        }
        if (x instanceof LispHalf) {
            return new LispHalf(DoubleUtils.toHalf(this.doubleValue() / x.getRealDouble()));
        }
        if (x instanceof LispFloat) {
            return new LispFloat(this.floatValue() / x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble(this.doubleValue() / x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.divide(this.getRealDecimal32(), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.divide(this.getRealDecimal64(), x.getRealDecimal64()));
        }
        if (x instanceof LispIrrational) {
            return new LispDouble(this.doubleValue() / x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispReal xr = x.getReal();
            LispReal xi = x.getImag();
            LispReal xn = xr.multiply(xr).add(xi.multiply(xi));
            if (x == LispComplex.INFINITY) {
                return this.isExact() ? LispInteger.ZERO : LispDouble.ZERO;
            }
            return LispComplex.newComplex(this.multiply(xr).divide(xn), this.multiply(xi).uminus().divide(xn));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.div(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.div(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispReal remainder(LispReal r) {
        if (!r.isExact()) {
            double x = Math.IEEEremainder(this.doubleValue(), r.doubleValue());
            return new LispDouble(x);
        }
        if (r.signum() > 0) {
            LispReal b = r;
            while (this.compareTo(r) > 0) {
                b = b.subtract(r);
            }
            return b;
        }
        LispReal b = r;
        while (this.compareTo(r) < 0) {
            b = b.add(r);
        }
        return b;
    }
}

