/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua.numeral;

import java.math.BigInteger;

public final class RomanNumeral {
    static String[] MILLE = new String[]{"", "M", "MM", "MMM"};
    static String[] CENT = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
    static String[] DECA = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
    static String[] UNUS = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
    private static final BigInteger X = BigInteger.valueOf(10L);
    private static final BigInteger L = BigInteger.valueOf(50L);
    private static final BigInteger C = BigInteger.valueOf(100L);
    private static final BigInteger D = BigInteger.valueOf(500L);

    private RomanNumeral() {
    }

    public static String toRoman(int n) {
        if (n <= 0 || n >= 4000) {
            return null;
        }
        int m = n / 1000;
        int c = n / 100 % 10;
        int d = n / 10 % 10;
        int u = n % 10;
        return String.valueOf(MILLE[m]) + CENT[c] + DECA[d] + UNUS[u];
    }

    public static int parse(String roman) {
        int r = 0;
        String s = roman.toUpperCase();
        int p = 0;
        while (true) {
            block80: {
                int m;
                int w;
                block88: {
                    block87: {
                        int c;
                        block86: {
                            block85: {
                                block84: {
                                    int d;
                                    block83: {
                                        block82: {
                                            int u;
                                            block81: {
                                                block79: {
                                                    w = p < s.length() ? (int)s.charAt(p) : -1;
                                                    u = r % 10;
                                                    if (u != 1) break block79;
                                                    switch (w) {
                                                        case 73: {
                                                            ++r;
                                                            break block80;
                                                        }
                                                        case 86: {
                                                            r += 3;
                                                            break block80;
                                                        }
                                                        case 88: {
                                                            r += 8;
                                                            break block80;
                                                        }
                                                        case -1: {
                                                            return r;
                                                        }
                                                        default: {
                                                            return -1;
                                                        }
                                                    }
                                                }
                                                if (u != 2 && u != 5 && u != 6 && u != 7) break block81;
                                                switch (w) {
                                                    case 73: {
                                                        ++r;
                                                        break block80;
                                                    }
                                                    case -1: {
                                                        return r;
                                                    }
                                                    default: {
                                                        return -1;
                                                    }
                                                }
                                            }
                                            if (u == 3 || u == 4 || u == 8 || u == 9) {
                                                switch (w) {
                                                    case -1: {
                                                        return r;
                                                    }
                                                }
                                                return -1;
                                            }
                                            d = r / 10 % 10;
                                            if (d != 1) break block82;
                                            switch (w) {
                                                case 73: {
                                                    ++r;
                                                    break block80;
                                                }
                                                case 86: {
                                                    r += 5;
                                                    break block80;
                                                }
                                                case 88: {
                                                    r += 10;
                                                    break block80;
                                                }
                                                case 76: {
                                                    r += 30;
                                                    break block80;
                                                }
                                                case 67: {
                                                    r += 80;
                                                    break block80;
                                                }
                                                case -1: {
                                                    return r;
                                                }
                                                default: {
                                                    return -1;
                                                }
                                            }
                                        }
                                        if (d != 2 && d != 5 && d != 6 && d != 7) break block83;
                                        switch (w) {
                                            case 73: {
                                                ++r;
                                                break block80;
                                            }
                                            case 86: {
                                                r += 5;
                                                break block80;
                                            }
                                            case 88: {
                                                r += 10;
                                                break block80;
                                            }
                                            case -1: {
                                                return r;
                                            }
                                            default: {
                                                return -1;
                                            }
                                        }
                                    }
                                    if (d != 3 && d != 4 && d != 8 && d != 9) break block84;
                                    switch (w) {
                                        case 73: {
                                            ++r;
                                            break block80;
                                        }
                                        case 86: {
                                            r += 5;
                                            break block80;
                                        }
                                        case -1: {
                                            return r;
                                        }
                                        default: {
                                            return -1;
                                        }
                                    }
                                }
                                c = r / 100 % 10;
                                if (c != 1) break block85;
                                switch (w) {
                                    case 73: {
                                        ++r;
                                        break block80;
                                    }
                                    case 86: {
                                        r += 5;
                                        break block80;
                                    }
                                    case 88: {
                                        r += 10;
                                        break block80;
                                    }
                                    case 76: {
                                        r += 50;
                                        break block80;
                                    }
                                    case 67: {
                                        r += 100;
                                        break block80;
                                    }
                                    case 68: {
                                        r += 300;
                                        break block80;
                                    }
                                    case 77: {
                                        r += 800;
                                        break block80;
                                    }
                                    case -1: {
                                        return r;
                                    }
                                    default: {
                                        return -1;
                                    }
                                }
                            }
                            if (c != 2 && c != 5 && c != 6 && c != 7) break block86;
                            switch (w) {
                                case 73: {
                                    ++r;
                                    break block80;
                                }
                                case 86: {
                                    r += 5;
                                    break block80;
                                }
                                case 88: {
                                    r += 10;
                                    break block80;
                                }
                                case 76: {
                                    r += 50;
                                    break block80;
                                }
                                case 67: {
                                    r += 100;
                                    break block80;
                                }
                                case -1: {
                                    return r;
                                }
                                default: {
                                    return -1;
                                }
                            }
                        }
                        if (c != 3 && c != 4 && c != 8 && c != 9) break block87;
                        switch (w) {
                            case 73: {
                                ++r;
                                break block80;
                            }
                            case 86: {
                                r += 5;
                                break block80;
                            }
                            case 88: {
                                r += 10;
                                break block80;
                            }
                            case 76: {
                                r += 50;
                                break block80;
                            }
                            case -1: {
                                return r;
                            }
                            default: {
                                return -1;
                            }
                        }
                    }
                    if (r != 0 && (m = r / 1000) != 1 && m != 2) break block88;
                    switch (w) {
                        case 73: {
                            ++r;
                            break block80;
                        }
                        case 86: {
                            r += 5;
                            break block80;
                        }
                        case 88: {
                            r += 10;
                            break block80;
                        }
                        case 76: {
                            r += 50;
                            break block80;
                        }
                        case 67: {
                            r += 100;
                            break block80;
                        }
                        case 68: {
                            r += 500;
                            break block80;
                        }
                        case 77: {
                            r += 1000;
                            break block80;
                        }
                        case -1: {
                            return r > 0 ? r : -1;
                        }
                        default: {
                            return -1;
                        }
                    }
                }
                if (m == 3) {
                    switch (w) {
                        case 73: {
                            ++r;
                            break;
                        }
                        case 86: {
                            r += 5;
                            break;
                        }
                        case 88: {
                            r += 10;
                            break;
                        }
                        case 76: {
                            r += 50;
                            break;
                        }
                        case 67: {
                            r += 100;
                            break;
                        }
                        case 68: {
                            r += 500;
                            break;
                        }
                        case -1: {
                            return r;
                        }
                        default: {
                            return -1;
                        }
                    }
                }
            }
            ++p;
        }
    }

    static void putNum1(StringBuffer r, int n, int d) {
        int j = 0;
        while (j < n) {
            if (d == 3) {
                r.append("C");
            } else {
                int i = 0;
                while (i < d - 3) {
                    r.append("C");
                    ++i;
                }
                r.append("I");
                i = 0;
                while (i < d - 3) {
                    r.append("\u2183");
                    ++i;
                }
            }
            ++j;
        }
    }

    public static String toBigRoman(BigInteger n) {
        StringBuffer r = new StringBuffer();
        boolean a = true;
        if (n == null) {
            throw new NullPointerException();
        }
        if (n.signum() <= 0) {
            throw new IllegalArgumentException();
        }
        if (n.compareTo(C) < 0) {
            return RomanNumeral.toRoman(n.intValue());
        }
        int q = n.remainder(C).intValue();
        String m = n.toString();
        int i = 0;
        while (i + 2 < m.length()) {
            int j;
            int d = m.charAt(i) - 48;
            if (d == 0) {
                a = true;
            } else if (d < 5) {
                RomanNumeral.putNum1(r, d, m.length() - i);
                a = false;
            } else if (d == 5) {
                if (a) {
                    r.append("I");
                }
                j = 0;
                while (j < m.length() - i - 2) {
                    r.append("\u2183");
                    ++j;
                }
                a = true;
            } else {
                if (a) {
                    r.append("I");
                }
                j = 0;
                while (j < m.length() - i - 2) {
                    r.append("\u2183");
                    ++j;
                }
                RomanNumeral.putNum1(r, d - 5, m.length() - i);
                a = false;
            }
            ++i;
        }
        if (q > 0) {
            r.append(RomanNumeral.toRoman(q));
        }
        return r.toString();
    }

    public static String toBigRoman(long n) {
        return RomanNumeral.toBigRoman(BigInteger.valueOf(n));
    }

    public static BigInteger parseBigRoman(String roman) {
        BigInteger rr = BigInteger.ZERO;
        int stat = 1000;
        int r = 0;
        int r1 = 0;
        int r2 = 0;
        int r3 = -1;
        int r4 = 0;
        String s = roman.toUpperCase();
        s = s.replace('\u216d', 'C');
        s = s.replaceAll("\u2180", "CI\u2183");
        s = s.replaceAll("\u2181", "I\u2183\u2183");
        s = s.replaceAll("\u2182", "CCI\u2183\u2183");
        int p = 0;
        while (true) {
            int w = p < s.length() ? (int)s.charAt(p) : -1;
            block0 : switch (stat) {
                case 1000: {
                    switch (w) {
                        case 73: {
                            stat = 1010;
                            break block0;
                        }
                        case 67: {
                            stat = 1020;
                            r1 = 2;
                            break block0;
                        }
                        case 88: {
                            stat = 2000;
                            r = 10;
                            break block0;
                        }
                        case 76: {
                            stat = 2000;
                            r = 50;
                            break block0;
                        }
                        case 86: {
                            stat = 2000;
                            r = 5;
                            break block0;
                        }
                    }
                    throw new NumberFormatException();
                }
                case 1010: {
                    switch (w) {
                        case 73: {
                            stat = 2000;
                            r = 2;
                            break block0;
                        }
                        case 86: {
                            stat = 2000;
                            r = 4;
                            break block0;
                        }
                        case 88: {
                            stat = 2000;
                            r = 9;
                            break block0;
                        }
                        case 8579: {
                            stat = 1030;
                            r2 = 1;
                            break block0;
                        }
                        case -1: {
                            return BigInteger.ONE;
                        }
                    }
                    throw new NumberFormatException();
                }
                case 1020: {
                    switch (w) {
                        case 67: {
                            r1 += 2;
                            break block0;
                        }
                        case 73: {
                            stat = 1040;
                            break block0;
                        }
                        case 88: {
                            stat = 2000;
                            r = 50 * r1 + 10;
                            break block0;
                        }
                        case 76: {
                            stat = 2000;
                            r = 50 * r1 + 50;
                            break block0;
                        }
                        case 86: {
                            stat = 2000;
                            r = 50 * r1 + 5;
                            break block0;
                        }
                        case -1: {
                            if (r1 > 8) {
                                throw new NumberFormatException();
                            }
                            return rr.add(BigInteger.valueOf(50 * r1));
                        }
                    }
                    throw new NumberFormatException();
                }
                case 1030: {
                    if (w == 8579) {
                        r2 += 2;
                        break;
                    }
                    if (r3 >= 0 && r2 >= r3) {
                        throw new NumberFormatException();
                    }
                    r3 = r2;
                    rr = rr.add(D.multiply(X.pow(r3 / 2)));
                    r2 = 0;
                    switch (w) {
                        case 73: {
                            stat = 1010;
                            break block0;
                        }
                        case 67: {
                            stat = 1020;
                            r1 = 2;
                            break block0;
                        }
                        case 88: {
                            stat = 2000;
                            r = 10;
                            break block0;
                        }
                        case 76: {
                            stat = 2000;
                            r = 50;
                            break block0;
                        }
                        case 86: {
                            stat = 2000;
                            r = 5;
                            break block0;
                        }
                        case -1: {
                            return rr;
                        }
                    }
                    throw new NumberFormatException();
                }
                case 1040: {
                    if (w == 8579) {
                        r2 += 2;
                        break;
                    }
                    if (r3 < 0 || r1 < r3) {
                        r4 = 1;
                        r3 = r1;
                    } else {
                        if (r1 > r3) {
                            throw new NumberFormatException();
                        }
                        if (r4++ >= 4) {
                            throw new NumberFormatException();
                        }
                    }
                    if (r2 < r1) {
                        throw new NumberFormatException();
                    }
                    if (r2 == r1) {
                        rr = rr.add(C.multiply(X.pow(r1 / 2)));
                    } else if (r2 <= r1 * 2) {
                        rr = rr.add(C.multiply(X.pow(r1 / 2)));
                        rr = rr.add(L.multiply(X.pow((r2 - r1) / 2)));
                    } else {
                        throw new NumberFormatException();
                    }
                    r2 = 0;
                    switch (w) {
                        case 73: {
                            stat = 1010;
                            break block0;
                        }
                        case 67: {
                            stat = 1020;
                            r1 = 2;
                            break block0;
                        }
                        case 88: {
                            stat = 2000;
                            r = 10;
                            break block0;
                        }
                        case 76: {
                            stat = 2000;
                            r = 50;
                            break block0;
                        }
                        case 86: {
                            stat = 2000;
                            r = 5;
                            break block0;
                        }
                        case -1: {
                            return rr;
                        }
                    }
                    throw new NumberFormatException();
                }
                case 2000: {
                    int u = r % 10;
                    if (u == 1) {
                        switch (w) {
                            case 73: {
                                ++r;
                                break block0;
                            }
                            case 86: {
                                r += 3;
                                break block0;
                            }
                            case 88: {
                                r += 8;
                                break block0;
                            }
                            case -1: {
                                return rr.add(BigInteger.valueOf(r));
                            }
                        }
                        throw new NumberFormatException();
                    }
                    if (u == 2 || u == 5 || u == 6 || u == 7) {
                        switch (w) {
                            case 73: {
                                ++r;
                                break block0;
                            }
                            case -1: {
                                return rr.add(BigInteger.valueOf(r));
                            }
                        }
                        throw new NumberFormatException();
                    }
                    if (u == 3 || u == 4 || u == 8 || u == 9) {
                        switch (w) {
                            case -1: {
                                return rr.add(BigInteger.valueOf(r));
                            }
                        }
                        throw new NumberFormatException();
                    }
                    int d = r / 10 % 10;
                    if (d == 1) {
                        switch (w) {
                            case 73: {
                                ++r;
                                break block0;
                            }
                            case 86: {
                                r += 5;
                                break block0;
                            }
                            case 88: {
                                r += 10;
                                break block0;
                            }
                            case 76: {
                                r += 30;
                                break block0;
                            }
                            case 67: {
                                r += 80;
                                break block0;
                            }
                            case -1: {
                                return rr.add(BigInteger.valueOf(r));
                            }
                        }
                        throw new NumberFormatException();
                    }
                    if (d == 2 || d == 5 || d == 6 || d == 7) {
                        switch (w) {
                            case 73: {
                                ++r;
                                break block0;
                            }
                            case 86: {
                                r += 5;
                                break block0;
                            }
                            case 88: {
                                r += 10;
                                break block0;
                            }
                            case -1: {
                                return rr.add(BigInteger.valueOf(r));
                            }
                        }
                        throw new NumberFormatException();
                    }
                    if (d != 3 && d != 4 && d != 8 && d != 9) break;
                    switch (w) {
                        case 73: {
                            ++r;
                            break block0;
                        }
                        case 86: {
                            r += 5;
                            break block0;
                        }
                        case -1: {
                            return rr.add(BigInteger.valueOf(r));
                        }
                    }
                    throw new NumberFormatException();
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++p;
        }
    }
}

