/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.string;

import java.io.Serializable;
import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.lang.string.ByteCharTable;
import net.morilib.lang.string.ByteSequence;
import net.morilib.lang.string.GenericString;

public class ByteString
extends GenericString<ByteString>
implements ByteSequence,
Serializable {
    private static final long serialVersionUID = 5378573669505615859L;
    public static final ByteCharTable ASCII = new ByteCharTable(){

        @Override
        public byte toByte(char c) {
            return c >= '\u0000' && c <= '\u007f' ? (byte)c : (byte)63;
        }

        @Override
        public char toChar(byte b) {
            return b >= 0 && b <= 127 ? (char)b : (char)'?';
        }
    };
    private static final ByteString TRUE_S = new ByteString("true");
    private static final ByteString FALSE_S = new ByteString("false");
    protected byte[] bytes;

    public ByteString() {
        this.bytes = new byte[0];
    }

    protected ByteString(byte[] bytes, boolean d) {
        this.bytes = bytes;
    }

    public ByteString(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ByteString(byte[] value, int offset, int count) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (offset + count > value.length) {
            throw new IllegalArgumentException();
        }
        this.bytes = new byte[count];
        System.arraycopy(value, offset, this.bytes, 0, count);
    }

    public ByteString(ByteString s) {
        this(s.bytes);
    }

    public ByteString(ByteSequence s) {
        this.bytes = new byte[s.length()];
        int i = 0;
        while (i < s.length()) {
            this.bytes[i] = s.byteAt(i);
            ++i;
        }
    }

    public ByteString(String s, ByteCharTable mp) {
        this.bytes = new byte[s.length()];
        int i = 0;
        while (i < s.length()) {
            this.bytes[i] = mp.toByte(s.charAt(i));
            ++i;
        }
    }

    public ByteString(String s) {
        this(s, ASCII);
    }

    public static ByteString valueOf(String s, ByteCharTable mp) {
        return new ByteString(s, mp);
    }

    @Override
    protected Object newArray(int size) {
        return new byte[size];
    }

    @Override
    protected Object getArray() {
        return this.bytes;
    }

    @Override
    protected ByteString returnString(Object a) {
        return new ByteString((byte[])a, false);
    }

    @Override
    protected boolean equalsAt(int index, byte b) {
        return this.bytes[index] == b;
    }

    @Override
    protected boolean equalsAt(int index, ByteString b, int indexB) {
        return this.bytes[index] == b.bytes[indexB];
    }

    @Override
    protected byte[] copyByteArray() {
        byte[] res = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, res, 0, this.bytes.length);
        return res;
    }

    @Override
    public byte byteAt(int index) {
        return this.bytes[index];
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    @Override
    public ByteSequence subSequence(int beginIndex, int endIndex) {
        return (ByteSequence)this.substring(beginIndex, endIndex);
    }

    @Override
    public ByteString toByteString() {
        return this;
    }

    public ByteString concat(String s, ByteCharTable mp) {
        return this.concat(ByteString.valueOf(s, mp));
    }

    @Override
    public ByteString concat(String s) {
        return this.concat(ByteString.valueOf(s, ASCII));
    }

    public boolean contains(String s, ByteCharTable mp) {
        return this.contains(ByteString.valueOf(s, mp));
    }

    @Override
    public boolean contains(String s) {
        return this.contains(ByteString.valueOf(s, ASCII));
    }

    public boolean containsEquals(ByteSequence s) {
        return this.contains(new ByteString(s));
    }

    public boolean containsEquals(String s, ByteCharTable mp) {
        return this.containsEquals(ByteString.valueOf(s, mp));
    }

    public boolean containsEquals(String s) {
        return this.containsEquals(ByteString.valueOf(s, ASCII));
    }

    public static ByteString copyValueOf(byte[] b) {
        return ByteString.copyValueOf(b, 0, b.length);
    }

    public static ByteString copyValueOf(byte[] b, int offset, int count) {
        return new ByteString(b, offset, count);
    }

    public boolean endsWith(String b, ByteCharTable mp) {
        return this.endsWith(ByteString.valueOf(b, mp));
    }

    @Override
    public boolean endsWith(String b) {
        return this.endsWith(ByteString.valueOf(b, ASCII));
    }

    public boolean equals(Object o) {
        if (o instanceof ByteString) {
            return Arrays.equals(this.bytes, ((ByteString)o).bytes);
        }
        return false;
    }

    public boolean equalsString(String s, ByteCharTable mp) {
        return this.equals(ByteString.valueOf(s, mp));
    }

    public boolean equalsString(String s) {
        return this.equals(ByteString.valueOf(s, ASCII));
    }

    public byte[] getBytes() {
        byte[] res = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, res, 0, this.bytes.length);
        return res;
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new IllegalArgumentException();
        }
        if (srcEnd < 0) {
            throw new IllegalArgumentException();
        }
        if (srcEnd > this.bytes.length) {
            throw new IllegalArgumentException();
        }
        if (dstBegin < 0) {
            throw new IllegalArgumentException();
        }
        if (dstBegin + (srcEnd - srcBegin) > dst.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.bytes, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public int hashCode() {
        return Hashes.sumHashCode(this.bytes);
    }

    @Override
    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    @Override
    public int indexOf(int ch, int fromIndex) {
        if (ch < -128 && ch > 255) {
            throw new IllegalArgumentException();
        }
        byte b = ch > 127 ? (byte)(ch - 256) : (byte)ch;
        return super.indexOf(b, fromIndex);
    }

    public int indexOf(String s, ByteCharTable mp) {
        return this.indexOf(ByteString.valueOf(s, mp), 0);
    }

    public int indexOf(String s, int fromIndex, ByteCharTable mp) {
        return this.indexOf(ByteString.valueOf(s, mp), fromIndex);
    }

    @Override
    public int indexOf(String s) {
        return this.indexOf(ByteString.valueOf(s, ASCII), 0);
    }

    @Override
    public int indexOf(String s, int fromIndex) {
        return this.indexOf(ByteString.valueOf(s, ASCII), fromIndex);
    }

    @Override
    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, 0);
    }

    @Override
    public int lastIndexOf(int ch, int fromIndex) {
        if (ch < -128 && ch > 255) {
            throw new IllegalArgumentException();
        }
        byte b = ch > 127 ? (byte)(ch - 256) : (byte)ch;
        return super.lastIndexOf(b, fromIndex);
    }

    public int lastIndexOf(String s, ByteCharTable mp) {
        return this.lastIndexOf(ByteString.valueOf(s, mp), 0);
    }

    public int lastIndexOf(String s, int fromIndex, ByteCharTable mp) {
        return this.lastIndexOf(ByteString.valueOf(s, mp), fromIndex);
    }

    @Override
    public int lastIndexOf(String s) {
        return this.lastIndexOf(ByteString.valueOf(s, ASCII), 0);
    }

    @Override
    public int lastIndexOf(String s, int fromIndex) {
        return this.lastIndexOf(ByteString.valueOf(s, ASCII), fromIndex);
    }

    @Override
    public ByteString replace(byte oldChar, byte newChar) {
        return (ByteString)super.replace(oldChar, newChar);
    }

    public boolean startsWith(String b, ByteCharTable mp) {
        return this.startsWith(ByteString.valueOf(b, mp));
    }

    @Override
    public boolean startsWith(String b) {
        return this.startsWith(ByteString.valueOf(b, ASCII));
    }

    public static ByteString valueOf(boolean v) {
        return v ? TRUE_S : FALSE_S;
    }

    public static ByteString valueOf(byte v) {
        byte[] res = new byte[]{v};
        return new ByteString(res, false);
    }

    public static ByteString valueOf(double v) {
        return ByteString.valueOf(String.valueOf(v), ASCII);
    }

    public static ByteString valueOf(float v) {
        return ByteString.valueOf(String.valueOf(v), ASCII);
    }

    public static ByteString valueOf(int v) {
        return ByteString.valueOf(String.valueOf(v), ASCII);
    }

    public static ByteString valueOf(long v) {
        return ByteString.valueOf(String.valueOf(v), ASCII);
    }

    public String toString(ByteCharTable t) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.bytes.length) {
            b.append(t.toChar(this.bytes[i]));
            ++i;
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return this.toString(ASCII);
    }
}

