/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.RegexPattern;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/04/09
 */
public class RegexpReplaceAll extends TernaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.TernaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(
			Datum c1a, Datum c2a, Datum c3a, Environment env,
			LispMessage mesg) {
		String  s = SubrUtils.getString(c2a, mesg);
		String  r = SubrUtils.getString(c3a, mesg);

		if(c1a instanceof RegexPattern) {
			Pattern p = ((RegexPattern)c1a).getPattern();
			Matcher m = p.matcher(s);

			return new LispString(m.replaceAll(r));
		} else if(c1a instanceof LispString) {
			try {
				Pattern p = Pattern.compile(c1a.getString());
				Matcher m = p.matcher(s);

				return new LispString(m.replaceAll(r));
			} catch(PatternSyntaxException e) {
				throw mesg.getError(
						"err.regexp.regex.syntax", c1a);
			}
		} else {
			throw mesg.getError("err.regexp.require.regexp", c1a);
		}
	}

}
