;;;
;;; Copyright 2009 Yuichiro Moriguchi
;;; 
;;; Licensed under the Apache License, Version 2.0 (the "License");
;;; you may not use this file except in compliance with the License.
;;; You may obtain a copy of the License at
;;; 
;;;     http://www.apache.org/licenses/LICENSE-2.0
;;; 
;;; Unless required by applicable law or agreed to in writing, software
;;; distributed under the License is distributed on an "AS IS" BASIS,
;;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;;; See the License for the specific language governing permissions and
;;; limitations under the License.

(define-sharp-quote "#'" 'syntax)
(define-sharp-quote "#`" 'quasisyntax)
(define-sharp-quote "#," 'unsyntax)
(define-sharp-quote "#,@" 'unsyntax-splicing)

;(define-syntax with-syntax
;  (lambda (x)
;    (syntax-case x ()
;      ((_ ((p e0) ...) e1 e2 ...)
;       (syntax (syntax-case (list e0 ...) ()
;                 ((p ...) (let () e1 e2 ...))))))))

(define (make-variable-transformer proc) proc)

;(define (syntax-error fmt . args)
;  (error (get-default-message
;           'err.syntaxcase.usererror
;           (format #f fmt args))))
(define-syntax syntax-error
  (syntax-rules ()
    ((_ fmt args ...)
      (error (get-default-message
               'err.syntaxcase.usererror
               (format #f fmt args ...))))))

(define (generate-temporaries l)
  (cond ((null? l) '())
         ((pair? l) (cons (generate-temporaries (car l))
                          (generate-temporaries (cdr l))))
         ((identifier? l) (gensym))
         (else l)))

