/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.morilib.util.iterator.CascadedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedSet<E>
extends AbstractSet<E> {
    Set<E> second = null;

    protected abstract Set<E> createSet();

    protected abstract Iterator<E> cacheIterator();

    protected abstract int cacheSize();

    protected abstract boolean isCacheFull();

    protected abstract int hitCache(Object var1);

    protected abstract E getCache(int var1);

    protected abstract void addCache(E var1);

    protected abstract void removeCache(int var1);

    protected abstract void setCache(int var1, E var2);

    protected abstract void clearCache();

    protected CachedSet() {
    }

    @Override
    public Iterator<E> iterator() {
        if (this.second != null) {
            return new CascadedIterator<E>(this.cacheIterator(), this.second.iterator());
        }
        return this.cacheIterator();
    }

    @Override
    public int size() {
        return this.cacheSize() + this.second.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheSize() == 0 && this.second.isEmpty();
    }

    private boolean containsWithoutCache(Object o) {
        return this.hitCache(o) >= 0 || this.second.contains(o);
    }

    @Override
    public boolean contains(Object o) {
        int ch = this.hitCache(o);
        if (ch >= 0) {
            return true;
        }
        if (this.second.contains(o)) {
            this.second.remove(o);
            this.second.add(this.getCache(0));
            this.setCache(0, o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.containsWithoutCache(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        if (this.hitCache(e) >= 0) {
            return false;
        }
        if (this.isCacheFull()) {
            if (this.second == null) {
                this.second = this.createSet();
            }
            return this.second.add(e);
        }
        this.addCache(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int ch = this.hitCache(o);
        if (ch >= 0) {
            this.removeCache(ch);
            return true;
        }
        if (this.second != null) {
            return this.second.remove(o);
        }
        return false;
    }

    @Override
    public void clear() {
        this.clearCache();
        if (this.second != null) {
            this.second.clear();
        }
    }
}

