/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.iterator;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummedIterator<E extends Comparable<E>>
implements Iterator<E> {
    private Iterator<E> iterator1;
    private Iterator<E> iterator2;
    private E val1;
    private E val2;

    public SummedIterator(Iterator<E> iterator1, Iterator<E> iterator2) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.val1 = iterator1.hasNext() ? (Comparable)iterator1.next() : null;
        this.val2 = iterator2.hasNext() ? (Comparable)iterator2.next() : null;
    }

    private int compareTo(E val1, E val2) {
        if (val1 == null) {
            return 1;
        }
        if (val2 == null) {
            return -1;
        }
        return val1.compareTo(val2);
    }

    @Override
    public boolean hasNext() {
        return this.val1 != null || this.val2 != null;
    }

    @Override
    public E next() {
        E res;
        if (this.compareTo(this.val1, this.val2) < 0) {
            res = this.val1;
            this.val1 = this.iterator1.hasNext() ? (Comparable)this.iterator1.next() : null;
        } else if (this.compareTo(this.val1, this.val2) > 0) {
            res = this.val2;
            this.val2 = this.iterator2.hasNext() ? (Comparable)this.iterator2.next() : null;
        } else {
            res = this.val1;
            this.val1 = this.iterator1.hasNext() ? (Comparable)this.iterator1.next() : null;
            this.val2 = this.iterator2.hasNext() ? (Comparable)this.iterator2.next() : null;
        }
        return res;
    }

    @Override
    public void remove() {
        throw new IllegalArgumentException();
    }
}

