/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.math.BigInteger;
import net.morilib.util.Inclementor;
import net.morilib.util.InclementorBoundsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntInclementor
implements Inclementor<Integer> {
    private int index;

    public IntInclementor() {
        this.index = 0;
    }

    public IntInclementor(int i) {
        this.index = i;
    }

    @Override
    public boolean isZero() {
        return this.index == 0;
    }

    @Override
    public Inclementor<Integer> suc() {
        if (++this.index > Integer.MAX_VALUE) {
            throw new InclementorBoundsException();
        }
        return this;
    }

    @Override
    public Inclementor<Integer> suc(int step) {
        if ((this.index += step) > Integer.MAX_VALUE) {
            throw new InclementorBoundsException();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof IntInclementor) {
            return this.index == ((IntInclementor)o).index;
        }
        return false;
    }

    public int hashCode() {
        return this.index;
    }

    @Override
    public boolean equalIncliment(Inclementor<?> i) {
        return this.index == i.toInt();
    }

    @Override
    public boolean equalInt(int i) {
        return this.index == i;
    }

    @Override
    public int toInt() {
        return this.index;
    }

    @Override
    public Integer getObject() {
        return new Integer(this.index);
    }

    @Override
    public boolean hasNext() {
        return this.index < Integer.MAX_VALUE;
    }

    @Override
    public Inclementor<Integer> getZero() {
        return new IntInclementor(0);
    }

    @Override
    public boolean equalInt(BigInteger i) {
        return i.equals(BigInteger.valueOf(this.index));
    }
}

