/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.functions;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.morilib.lang.Equivalence;
import net.morilib.lang.algebra.FieldElement;
import net.morilib.lang.algebra.UnitaryRingElement;
import net.morilib.lang.monad.BooleanMonad;
import net.morilib.math.functions.Factor;
import net.morilib.math.functions.Polynomial1Coefficients;
import net.morilib.math.functions.SortedMapPolynomial1Coefficients;
import net.morilib.util.Maps;
import net.morilib.util.MethodLocal;
import net.morilib.util.set.quotient.Classifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polynomial<F extends Comparable<F>, C extends FieldElement<C>>
implements UnitaryRingElement<Polynomial<F, C>>,
Serializable {
    private static final long serialVersionUID = 7611588386752523588L;
    private final Maps.Transform2<C> _add = new Maps.Transform2<C>(){
        private static final long serialVersionUID = -1554655061800510876L;

        @Override
        public C transform(C x, C y) {
            if (x == null) {
                return y == null ? null : (Object)y;
            }
            return y == null ? x : (FieldElement)x.add(y);
        }
    };
    private final Maps.Transform2<C> _sub = new Maps.Transform2<C>(){
        private static final long serialVersionUID = -1554655061800510876L;

        @Override
        public C transform(C x, C y) {
            if (x == null) {
                return y == null ? null : (FieldElement)y.negate();
            }
            return y == null ? x : (FieldElement)x.subtract(y);
        }
    };
    private Map<Factor<F>, C> coefficients = new TreeMap<Factor<F>, C>();

    public Polynomial(C coefficient, Factor<F> factor) {
        if (!factor.isPolynomial()) {
            throw new IllegalArgumentException();
        }
        this.coefficients.put(factor, coefficient);
    }

    public Polynomial(C coefficient, F var) {
        this.coefficients.put(new Factor<F>(var), coefficient);
    }

    public Polynomial(C coefficient) {
        if (!coefficient.isZero()) {
            this.coefficients.put(new Factor(), coefficient);
        }
    }

    public Polynomial() {
    }

    private void del0() {
        Iterator<Map.Entry<Factor<F>, C>> i1 = this.coefficients.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry<Factor<F>, C> e1 = i1.next();
            if (!((FieldElement)e1.getValue()).isZero()) continue;
            i1.remove();
        }
    }

    @Override
    public boolean isUnit() {
        if (this.coefficients.size() == 1) {
            Map.Entry<Factor<F>, C> e = this.coefficients.entrySet().iterator().next();
            return e.getKey().isConstant() && ((FieldElement)e.getValue()).isUnit();
        }
        return false;
    }

    @Override
    public boolean isZero() {
        return this.coefficients.isEmpty();
    }

    @Override
    public Polynomial<F, C> negate() {
        Polynomial<F, C> res = new Polynomial<F, C>();
        res.coefficients = Maps.map(new Maps.Transform<C>(){

            @Override
            public C transform(C o) {
                return (FieldElement)o.negate();
            }
        }, new TreeMap(), this.coefficients);
        return res;
    }

    @Override
    public Polynomial<F, C> subtract(Polynomial<F, C> x) {
        Polynomial<F, C> res = new Polynomial<F, C>();
        res.coefficients = Maps.map(this._sub, new TreeMap(), this.coefficients, x.coefficients);
        super.del0();
        return res;
    }

    @Override
    public Polynomial<F, C> add(Polynomial<F, C> x) {
        Polynomial<F, C> res = new Polynomial<F, C>();
        res.coefficients = Maps.map(this._add, new TreeMap(), this.coefficients, x.coefficients);
        super.del0();
        return res;
    }

    private void _add(C c, Factor<F> x) {
        FieldElement d = (FieldElement)this.coefficients.get(x);
        if (d != null) {
            if (!(d = c.add((FieldElement)d)).isZero()) {
                this.coefficients.put(x, d);
            } else {
                this.coefficients.remove(x);
            }
        } else {
            this.coefficients.put(x, c);
        }
    }

    @Override
    public Polynomial<F, C> multiply(int n) {
        Polynomial<F, C> res = new Polynomial<F, C>();
        final int y = n;
        res.coefficients = Maps.map(new Maps.Transform<C>(){

            @Override
            public C transform(C x) {
                return (FieldElement)x.multiply(y);
            }
        }, new TreeMap(), this.coefficients);
        super.del0();
        return res;
    }

    @Override
    public Polynomial<F, C> multiply(C n) {
        Polynomial<F, C> res = new Polynomial<F, C>();
        C y = n;
        res.coefficients = Maps.map(new Maps.Transform<C>((FieldElement)y){
            private final /* synthetic */ FieldElement val$y;
            {
                this.val$y = fieldElement;
            }

            @Override
            public C transform(C x) {
                return x.multiply((FieldElement)this.val$y);
            }
        }, new TreeMap(), this.coefficients);
        super.del0();
        return res;
    }

    public Polynomial<F, C> multiply(C c, Factor<F> x) {
        Polynomial<F, C> res = new Polynomial<F, C>();
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            FieldElement d = (FieldElement)((FieldElement)e.getValue()).multiply(c);
            if (d.isZero()) continue;
            res.coefficients.put(e.getKey().multiply(x), d);
        }
        super.del0();
        return res;
    }

    @Override
    public Polynomial<F, C> multiply(Polynomial<F, C> x) {
        Polynomial<F, FieldElement> res = new Polynomial<F, FieldElement>();
        for (Map.Entry<Factor<F>, C> e : x.coefficients.entrySet()) {
            res = res.add(this.multiply((FieldElement)e.getValue(), e.getKey()));
        }
        return res;
    }

    public Polynomial<F, C> divide(C n) {
        Polynomial<F, C> res = new Polynomial<F, C>();
        C y = n;
        res.coefficients = Maps.map(new Maps.Transform<C>((FieldElement)y){
            private final /* synthetic */ FieldElement val$y;
            {
                this.val$y = fieldElement;
            }

            @Override
            public C transform(C x) {
                return x.divide((FieldElement)this.val$y);
            }
        }, new TreeMap(), this.coefficients);
        super.del0();
        return res;
    }

    @Override
    public Polynomial<F, C> power(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return new Polynomial<F, C>();
        }
        Polynomial<F, C> res = this;
        int i = 1;
        while (i < n) {
            res = res.multiply(res);
            ++i;
        }
        return res;
    }

    public boolean isConstant() {
        if (this.coefficients.isEmpty()) {
            return true;
        }
        if (this.coefficients.size() == 1) {
            Map.Entry<Factor<F>, C> e = this.coefficients.entrySet().iterator().next();
            return e.getKey().isConstant();
        }
        return false;
    }

    public boolean isLinear() {
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            if (e.getKey().isLinear()) continue;
            return false;
        }
        return true;
    }

    public boolean isLinearOf(F var) {
        int res = 0;
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            if (!e.getKey().containsVariable(var)) continue;
            if (!e.getKey().isLinear()) {
                return false;
            }
            if (e.getKey().getOrder(var) != 1) {
                return false;
            }
            if (++res <= 1) continue;
            return false;
        }
        return res > 0;
    }

    public Polynomial<F, C> substitute(F var, Polynomial<F, C> val) {
        Polynomial<F, FieldElement> res = new Polynomial<F, FieldElement>();
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            if (e.getKey().containsVariable(var)) {
                int o = e.getKey().getOrder(var);
                res = res.add(((Polynomial)val.power(o)).multiply((FieldElement)e.getValue(), e.getKey().removeVariable(var)));
                continue;
            }
            super._add((FieldElement)e.getValue(), e.getKey());
        }
        return res;
    }

    public Polynomial<F, C> solveLinear(F var) {
        Polynomial<F, FieldElement> res = new Polynomial<F, FieldElement>();
        FieldElement coeff = null;
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            if (e.getKey().containsVariable(var)) {
                if (!e.getKey().isLinear()) {
                    return null;
                }
                coeff = (FieldElement)e.getValue();
                continue;
            }
            res.coefficients.put(e.getKey(), (FieldElement)e.getValue());
        }
        if (coeff == null) {
            return null;
        }
        return res.divide(coeff).negate();
    }

    public Polynomial<F, C> substituteVariables(Map<F, F> map) {
        Polynomial<F, C> res = new Polynomial<F, C>();
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            Factor<F> g = e.getKey().replaceVariables(map);
            if (g != null) {
                super._add((FieldElement)e.getValue(), g);
                continue;
            }
            super._add((FieldElement)e.getValue(), e.getKey());
        }
        return res;
    }

    public void collectVariables(Set<F> res) {
        for (Factor<F> f : this.coefficients.keySet()) {
            f.collectVariables(res);
        }
    }

    public C getConstant() {
        FieldElement c = (FieldElement)this.coefficients.get(new Factor());
        return (C)c;
    }

    public Polynomial<F, C> differenciate(F val) {
        Polynomial<F, C> res = new Polynomial<F, C>();
        TreeMap<Factor<F>, C> rmp = new TreeMap<Factor<F>, C>();
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            if (!e.getKey().containsVariable(val)) continue;
            int n = e.getKey().getOrder(val);
            rmp.put(e.getKey().differenciate(val), (FieldElement)((FieldElement)e.getValue()).multiply(n));
        }
        res.coefficients = rmp;
        super.del0();
        return res;
    }

    public C substituteAll(Map<F, C> values) {
        HashSet vals = new HashSet();
        FieldElement res = null;
        this.collectVariables(vals);
        if (!values.keySet().containsAll(vals)) {
            return null;
        }
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            FieldElement r1 = e.getKey().replaceAll(values).multiply((FieldElement)((FieldElement)e.getValue()));
            FieldElement fieldElement = res = res == null ? r1 : res.add(r1);
        }
        return (C)res;
    }

    public boolean containsVariable(F var) {
        for (Factor<F> f : this.coefficients.keySet()) {
            if (!f.containsVariable(var)) continue;
            return true;
        }
        return false;
    }

    public boolean equalsWithoutVariable(Polynomial<F, C> polynomial, Set<F> v) {
        final Set<F> var = v;
        final MethodLocal<BooleanMonad> mnd = new MethodLocal<BooleanMonad>(BooleanMonad.TRUE);
        Equivalence eqv = new Equivalence<Factor<F>, Factor<F>>(){

            @Override
            public boolean isEquivalent(Factor<F> a, Factor<F> b) {
                return a.removeVariables(var).equals(b.removeVariables(var));
            }

            @Override
            public Factor<F> classify(Factor<F> o) {
                return o.removeVariables(var);
            }
        };
        if (this.coefficients.size() != polynomial.coefficients.size()) {
            return false;
        }
        Maps.each(new Maps.Each2<Set<C>>(){

            @Override
            public void each(Set<C> a, Set<C> b) {
                if (a == null || b != null || !a.equals(b)) {
                    mnd.set(((BooleanMonad)mnd.get()).bind(BooleanMonad.RESET));
                }
            }
        }, Classifier.classify(this.coefficients, eqv), Classifier.classify(polynomial.coefficients, eqv));
        return mnd.get().getValue();
    }

    public F getSingleVariable() {
        Comparable var = null;
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            Factor<Comparable> f = e.getKey();
            if (!f.isSingleVariable()) {
                return null;
            }
            if (var == null) {
                Iterator iterator = f.orders.keySet().iterator();
                while (iterator.hasNext()) {
                    Comparable g;
                    var = g = (Comparable)iterator.next();
                }
                continue;
            }
            if (f.isConstant() || f.containsVariable(var)) continue;
            return null;
        }
        return (F)var;
    }

    public Polynomial1Coefficients<C> toPolynomial1Coefficients() {
        Comparable var = null;
        TreeMap<Integer, FieldElement> s = new TreeMap<Integer, FieldElement>();
        for (Map.Entry<Factor<F>, C> e : this.coefficients.entrySet()) {
            Factor<Comparable> f = e.getKey();
            if (!f.isSingleVariable()) {
                return null;
            }
            if (var == null) {
                Iterator iterator = f.orders.keySet().iterator();
                while (iterator.hasNext()) {
                    Comparable g;
                    var = g = (Comparable)iterator.next();
                }
            } else if (!f.isConstant() && !f.containsVariable(var)) {
                return null;
            }
            s.put(f.isConstant() ? 0 : f.getOrder(var), (FieldElement)e.getValue());
        }
        return new SortedMapPolynomial1Coefficients(s);
    }

    public boolean equals(Object o) {
        if (o instanceof Polynomial) {
            return this.coefficients.equals(((Polynomial)o).coefficients);
        }
        return false;
    }

    public int hashCode() {
        return this.coefficients.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String a = "";
        for (Map.Entry<Factor<F>, C> m : this.coefficients.entrySet()) {
            FieldElement v = (FieldElement)m.getValue();
            buf.append(a);
            if (!v.isUnit() || m.getKey().isConstant()) {
                buf.append(v);
            }
            if (!m.getKey().isConstant()) {
                buf.append(m.getKey());
            }
            a = " + ";
        }
        return buf.toString();
    }
}

