/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousArray;
import net.morilib.util.primitive.IntegerArrayVector;
import net.morilib.util.uvector.IntArray;

public class LispS32Vector
extends Atom
implements HomogeneousArray {
    private IntArray vector;

    private LispS32Vector() {
    }

    public LispS32Vector(int ... bs) {
        this.vector = IntArray.newArray(bs);
    }

    public static LispS32Vector malloc(int size) {
        LispS32Vector res = new LispS32Vector();
        res.vector = IntArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        if (!(d instanceof LispReal)) {
            return false;
        }
        return ((LispReal)d).inIntRange();
    }

    private static int[] toIntList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        IntegerArrayVector v = new IntegerArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispS32Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.s32", d);
            }
            v.add(d.getInt());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toIntArray();
    }

    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#s32(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(this.vector.getInt(i));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    public String getResult() {
        return this.print();
    }

    public LispString toLispString() {
        return new LispString(this.print());
    }

    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispS32Vector)) {
            return false;
        }
        if (!(d2 instanceof LispS32Vector)) {
            return false;
        }
        return ((LispS32Vector)d1).vector.equals(((LispS32Vector)d2).vector);
    }

    public LispInteger get(int index) {
        return LispInteger.valueOf(this.vector.getInt(index));
    }

    public void set(int index, LispReal x) {
        this.vector.setInt(index, x.castInt());
    }

    public int size() {
        return this.vector.size();
    }

    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispS32Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.s32", x);
        }
    }

    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    public static class EqualS32Vector
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispS32Vector)) {
                throw mesg.getError("err.uvector.require.s32", c1a);
            }
            if (!(c2a instanceof LispS32Vector)) {
                throw mesg.getError("err.uvector.require.s32", c2a);
            }
            return LispBoolean.getInstance(((LispS32Vector)c1a).vector.equals(((LispS32Vector)c2a).vector));
        }
    }

    public static class IsS32Vector
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispS32Vector);
        }
    }

    public static class ListToS32Vector
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispS32Vector(LispS32Vector.toIntList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeS32Vector
    extends Subr {
        private int[] makeVector(int len, int d) {
            IntegerArrayVector b = new IntegerArrayVector();
            int i = 0;
            while (i < len) {
                b.add(d);
                ++i;
            }
            return b.toIntArray();
        }

        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispS32Vector(this.makeVector(t, 0));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispS32Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.s32", lst.get(1));
                }
                return new LispS32Vector(this.makeVector(t, lst.get(1).getInt()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class S32Vector
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispS32Vector(LispS32Vector.toIntList(body, mesg));
        }
    }

    public static class S32VectorToList
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispS32Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispS32Vector v = (LispS32Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(LispInteger.valueOf(v.vector.getInt(i)));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.s32", c1a);
        }
    }
}

